# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import os

import numpy as np
import pandas as pd
import pytest

import pmlib
from pmlib import api


APM_ID = os.environ['APM_ID']
APM_API_BASEURL = os.environ['APM_API_BASEURL']
APM_API_KEY = os.environ['APM_API_KEY']

PMLIB_URL_FORMAL = '%s/ibm/pmi/service/rest/ds/%s/%s/lib/download?filename=pmlib-1.0.0.tar.gz' % (APM_API_BASEURL, APM_ID, APM_API_KEY)
PMLIB_URL_BRANCH = 'git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@%s'

OOTB_TEMPLATES = {
    'TimeToFailureAssetGroupPipeline',
    'DegradationCurveAssetGroupPipeline',
    'FailurePredictionAssetGroupPipeline',
    'SimpleCustomAssetGroupPipelineLoader',
    'AnomalyDetectionAssetGroupPipeline',
    'WmlScoringAssetGroupPipeline',
}


def test(branch=None):
    url = PMLIB_URL_FORMAL if branch is None else (PMLIB_URL_BRANCH % branch)
    print(url)

    resp = api.get_catalog_function()
    if resp is None:
        raise RuntimeError()

    resp = resp.json()
    for template in resp:
        function_name = template['name']
        print(function_name)
        if function_name not in OOTB_TEMPLATES:
            continue

        print(template['url'])
        if template['url'] == url:
            continue

        old_url = template['url']
        template['url'] = url
        api.update_catalog_function(function_name, template)
        print('updated function=%s, url: %s => %s' % (function_name, old_url, template['url']))


if __name__ == '__main__':
    # test(branch='preprocessor-injection')
    test(branch='master')
    # test()

