# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import dill
import numpy as np

print('runtime using dill_version=%s, numpy_version=%s\n' % (dill.__version__, np.__version__))

for dill_version in ['029']:
    for version in ['1146', '1173']:
        print('models saved using dill_version=%s, numpy_version=%s' % (dill_version, version))
        for model in ['fp', 'rca', 'ttf', 'ad']:
            model_path = './model_%s_%s_%s' % (model, version, dill_version)

            m = None
            try:
                with open(model_path, mode='rb') as file:
                    m = dill.loads(file.read())
            except Exception as e:
                print('%s failure: %s' % (model_path, e))
            else:
                str(m)
                print('%s success' % model_path)
        print()

