# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib


def test():
    #workin on 12-12-2019
    asset_group_id='4227'
    #asset_group_id='4206'

    

    device_type= 'LOBControllerSensor20200415'
    device_id='LOBControllerSensor20200415_D1'
    site_id = 'BEDFORD'

    asset_device_mappings={'LOBA20-____-BEDFORD': ['%s:%s' % (device_type, device_id)]}

    desired_features = ['maxsecondarycurrent','avgvoltage' ]
    bug_device_type_qualified_features = [device_type+':'+col for col in desired_features]

    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent', 'avgsecondarycurrent',  'avgvoltage']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]




    from srom.utils.no_op import NoOp
    from sklearn.ensemble import RandomForestClassifier

    feature_transformation_set = [('skip_transformation', NoOp())]
    feature_scaler_set = [('skip_scaling', NoOp())]
    feature_preprocessing_set = [('skip_selection', NoOp())]
    estimator_feature_generator_set = [('skip_generation', NoOp())]
    estimator_set = [('randomforestclassifier', RandomForestClassifier(max_depth=15, max_features='sqrt', min_samples_leaf=2, min_samples_split=3, n_estimators=200, n_jobs=-1))]

    my_stages = [
        feature_transformation_set,
        feature_scaler_set,
        feature_preprocessing_set,
        estimator_feature_generator_set,
        estimator_set
    ]
    print(my_stages)

    group = pmlib.FailurePredictionAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features': device_type_qualified_features,
                    'predictions': ['failure_probability','rca_path'],
                    'aggregation_methods': ['min'],
                    'prediction_window_size': '9d'
                    #"override_training_stages": my_stages

                }
            )
    #df = group.execute(start_ts='2017-01-01', end_ts='2017-02-01')
    df = group.execute()
    #group.register()

    print(pmlib.log_df_info(df, head=0))


if __name__ == '__main__':
    test()

