# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib
from pmlib import api


def test(asset_group_id, iot_type, deviceid_prefix, assetid_prefix, siteid='BEDFORD'):
    resp = api.get_model_instance(asset_group_id=asset_group_id)
    if resp is not None:
        resp = resp.json()
    for template_instances in resp['modelInstanceList']:
        for instance in template_instances['instanceList']:
            if api.unregister_model_instance(asset_group_id=asset_group_id, model_instance_id=instance['modelInstanceId'], force=True) is not None:
                print('deleted model_instance_id=%s ...' % instance['modelInstanceId'], end=' ')


if __name__ == '__main__':
    test(asset_group_id='abcd5', iot_type='BrakeSensor1030', assetid_prefix='BRAKE1030', siteid='BEDFORD', deviceid_prefix='Brake1030')

