# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

def test():
    import argparse
    from ..api import get_maximo_asset_group_id
    from ..time_to_failure import TimeToFailureAssetGroupPipeline
    from ..util import log_df_info


    #TimeToFailureAssetGroupPipeline.generate_sample_data(sensor_type_name='IntgFailureSensor', site_id='BEDFORD')
    #needs to take 1016 as a parameter
    parser = argparse.ArgumentParser()
    parser.add_argument('--option', help='Pass the action you want to execute')
    parser.add_argument('--asset_group_name', help='Asset Group Id')
    parser.add_argument('--asset_query', help="Asset query name")
    parser.add_argument('--sensor_type_name', help='Pass the Sensor Type ( WIoTP Device Type )')
    parser.add_argument('--sensor_id_prefix', help='Pass the prefix of the Sensor Id (WIoTP Device Id)')
    parser.add_argument('--extra_option', help='Extra option used by the WIoTP Simulator')
    parser.add_argument('--site_id', help='Asset Site Id')
    parser.add_argument('--asset_num_prefix', help='Asset Num Prefix')
    parser.add_argument('--asset_start_num', help='Asset Start Num')
    parser.add_argument('--asset_total', help='Number of Assets')
    parser.add_argument('--model', help="Predictive Model")
    parser.add_argument('--env', help="Target Environment")
    args = parser.parse_args()


    features = []
    for i in range(1,4):
        features.append(args.sensor_type_name+":sensor_"+str(i))

    asset_device_mappings = {'%s%04d-____-%s' % (args.asset_num_prefix, i, args.site_id): ['%s:%s%1d_SENSOR_00' % (args.sensor_type_name, args.sensor_id_prefix, i)] for i in range(int(args.asset_start_num), int(args.asset_start_num) + int(args.asset_total))}

    group = TimeToFailureAssetGroupPipeline(
                asset_group_id=get_maximo_asset_group_id(args.asset_group_name),
                model_pipeline={
                    'features': features,                
                    'features_for_training': [':installdate', ':faildate'],
                    'predictions': ['predicted_time_to_failure'],
                },
                asset_device_mappings=asset_device_mappings)            
    # group.set_asset_device_mappings(asset_device_mappings)
    df = group.execute()

    print(log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(df=df)

    # group.unregister()


if __name__ == '__main__':
    test()

