# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pandas as pd
import os
import pmlib
from pmlib.api import init_environ
from pmlib.util import current_directory
from pmlib import api

def print_resp(resp, msg=''):
    '''Quick method for printing out response content.
    '''
    print(str(resp))
    if resp is not None:
        print(resp.text)
    else:
        raise RuntimeError(msg)


def test():
    pmlib.setup_logging()

    init_environ()
    asset_group_id = os.environ.get('asset_group_id', 9999)
    iot_type = os.environ.get('iot_type', 'TrainBrakeSensor')

    current_directory = pmlib.util.current_directory(__file__)
    print(current_directory)

    df= pd.read_csv('%s/trainbrake_mappings.csv' % current_directory)
    #pmlib.delete_assets(df, siteid_column='site', assetid_column='asset') this is for maximo

    pmlib.delete_asset_group_members(asset_group_id)
    pmlib.delete_asset_device_mappings(df=df)

    pmlib.delete_iot_type(name=iot_type)

    df= pd.read_csv('%s/trainbrake_asset_faildates.csv' % current_directory)
    api.delete_asset_cache(df, siteid_column='site', assetid_column='asset')
    #resp = pmlib.delete_asset_failure_history(df, siteid_column='site', assetid_column='asset')
    #print_resp(resp)
    
    df= pd.read_csv('%s/trainbrake_asset_attributes.csv' % current_directory)
    api.delete_asset_cache_dimension(df, siteid_column='site', assetid_column='asset')
    #resp = pmlib.delete_assets(df, siteid_column='site', assetid_column='asset')
    #print_resp(resp)

if __name__ == '__main__':
    test()


