# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import os
import pmlib
from pmlib.api import init_environ
from pmlib.util import current_directory
from iotfunctions.db import Database
from pmlib import api


def print_resp(resp, msg=''):
    '''Quick method for printing out response content.'''
    print(str(resp))
    if resp is not None:
        print(resp.text)
    else:
        raise RuntimeError(msg)


def test():
    pmlib.setup_logging()
    init_environ()
    current_directory = pmlib.util.current_directory(__file__)
    print(current_directory)

    asset_group_id = os.environ.get('asset_group_id', 9999)
    iot_type = os.environ.get('iot_type', 'TrainBrakeSensor')

    df = pd.read_csv('%s/trainbrake_device_data.csv' % current_directory)
    print(df.head())

    t = pmlib.setup_iot_type(
        name=iot_type, 
        df=df, 
        columns=[
            'TRAINBRAKESIMULATION_NUMBEROFPASSENGERS', 
            'TRAINBRAKESIMULATION_HUMIDITY', 
            'TRAINBRAKESIMULATION_LOAD',
            'TRAINBRAKESIMULATION_AXLEVIBRATION',
            'TRAINBRAKESIMULATION_TEMP',
            'TRAINBRAKESIMULATION_OBSCOND',
            'TRAINBRAKESIMULATION_RUNHOURS',
            'TRAINBRAKESIMULATION_WHEELSPEED',
            'TRAINBRAKESIMULATION_AXLEMOMENTUM',
        ], 
        deviceid_column='deviceid',
        timestamp_column='rcv_timestamp_utc', 
        timestamp_in_payload=True,
        rename_columns={
            'RCV_TIMESTAMP_UTC': 'customtime',
            'TRAINBRAKESIMULATION_NUMBEROFPASSENGERS': 'passengers', 
            'TRAINBRAKESIMULATION_HUMIDITY': 'humidity', 
            'TRAINBRAKESIMULATION_LOAD': 'load',
            'TRAINBRAKESIMULATION_AXLEVIBRATION': 'axlevibration',
            'TRAINBRAKESIMULATION_TEMP': 'temp',
            'TRAINBRAKESIMULATION_OBSCOND': 'obscond',
            'TRAINBRAKESIMULATION_RUNHOURS': 'runhours',
            'TRAINBRAKESIMULATION_WHEELSPEED': 'wheelspeed',
            'TRAINBRAKESIMULATION_AXLEMOMENTUM': 'axlemomentum',
        },
        write='deletefirst',
        use_wiotp=False)

    df= pd.read_csv('%s/trainbrake_mappings.csv' % current_directory)
    df['devicetype'] = iot_type
    print(df.head())
    pmlib.set_asset_device_mappings(df=df, delete_df_asset_first=True, drop_table_first=False)

    df= pd.read_csv('%s/trainbrake_asset_faildates.csv' % current_directory)
    df['devicetype'] = iot_type
    print(df.head())
    api.set_asset_cache(df=df, delete_df_asset_first=True)

    df= pd.read_csv('%s/trainbrake_asset_attributes.csv' % current_directory)
    print(df.head())
    api.set_asset_cache_dimension(df=df)

    df= pd.read_csv('%s/trainbrake_mappings.csv' % current_directory)
    df['devicetype'] = iot_type
    print(df.head())
    api.set_asset_group_members(asset_group_id, df, siteid_column='site', assetid_column='asset', db=None, db_schema=None, drop_table_first=False)


if __name__ == '__main__':
    test()

