# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import os

import numpy as np
import pandas as pd

import pmlib
from pmlib import api
from pmlib.api import init_environ
from pmlib.util import current_directory


def test():
    pmlib.setup_logging()

    init_environ()
    asset_group_id = os.environ.get('asset_group_id', 9999)
    iot_type = os.environ.get('iot_type', 'TrainBrakeSensor')

    current_directory = current_directory(__file__)
    print(current_directory)

    db = api._get_db()

    entity_type = api._get_asset_cache_entity_type(db=db)
    api._get_asset_group_table(db=db)
    print(entity_type.get_data())


    df= pd.read_csv('%s/trainbrake_asset_faildates.csv' % current_directory)
    df['devicetype'] = iot_type
    print("df.head()")
    print(df.head())

    api.set_asset_cache(df=df, delete_df_asset_first=True, drop_table_first=True)

    df= pd.read_csv('%s/trainbrake_asset_attributes.csv' % current_directory)
    print("df.head()")
    print(df.head())

    api.set_asset_cache_dimension(df=df, delete_df_asset_first=True)

    df= pd.read_csv('%s/trainbrake_mappings.csv' % current_directory)
    df['devicetype'] = iot_type
    print("df.head()")
    print(df.head())
    api.set_asset_group_members(asset_group_id, df, siteid_column='site', assetid_column='asset', db=None, db_schema=None, delete_table_first=False, drop_table_first=False)


if __name__ == '__main__':
    test()

