# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib


def test():
    asset_group_id='9999'

    group = pmlib.TimeToFailureAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features': ['TrainBrakeSensor:axlevibration', 'TrainBrakeSensor:axlemomentum'],
                    'features_for_training': [':installdate', ':faildate'],
                    'predictions': ['predicted_time_to_failure'],
                })
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))
    group.register(url = 'git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git')
    # group.unregister()


if __name__ == '__main__':
    test()

