# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

from ..failure_prediction import FailurePredictionAssetGroupPipeline
from ..util import log_df_info
from ..api import get_maximo_asset_group_id
import time


def test():
    '''
    This test script uses 1 asset, PMI_ASSET111, and 1 sensor, sample_sensor111 of device type SampleFailureSensor, to train the failure probability model.

    It loads from 'data.csv' the 3 sensor data (sensor_1, sensor_2, sensor_3) as well as extracting the asset failure history. The data file contains a flag indicating failure event.
    '''
    asset_group_id = get_maximo_asset_group_id('INTGGROUP'),
    sensor_type_name = 'IntgFailureSensor'
    sensor_id_prefix = 'INTAT_000'
    site_id = 'BEDFORD'
    asset_num_prefix = 'INTAT_000'
    asset_start_num = 0

    asset_device_mappings = FailurePredictionAssetGroupPipeline.generate_sample_data(sensor_type_name=sensor_type_name, sensor_id_prefix=sensor_id_prefix, site_id=site_id, asset_num_prefix=asset_num_prefix, asset_start_num=asset_start_num)
    print("asset_device_mappings")
    print(asset_device_mappings)
    time.sleep(3)

    group = FailurePredictionAssetGroupPipeline(
                asset_group_id=get_maximo_asset_group_id('INTGGROUP'),
                model_pipeline={
                    'features': ['IntgFailureSensor:sensor_1', 'IntgFailureSensor:sensor_2', 'IntgFailureSensor:sensor_3'],
                    'features_for_training': [':faildate'],
                    'predictions': ['failure_probability_15d', 'rca_path_15d'],
                    'aggregation_methods': ['mean', 'max', 'min', 'median', 'std', 'sum', 'count'],
                    'prediction_window_size': '15d',
                },
                asset_device_mappings=asset_device_mappings) #runtime

    df = group.execute()


    print(log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(df=df)
    # group.unregister()


if __name__ == '__main__':
    test()

