# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd

from ..api import get_maximo_asset_group_id
from ..degradation_curve import DegradationCurveAssetGroupPipeline
from ..util import log_df_info

def test():
    '''
    This test script uses 100 assets, PMI_ASSET001 through PMI_ASSET100, to generate a curve for the group.

    It loads from 'asset_data.csv' the asset's installdate and decommissiondate into Maximo.
    '''

    group = DegradationCurveAssetGroupPipeline(
                asset_group_id=get_maximo_asset_group_id('INTGGROUP'),
                model_pipeline={
                    # first feature for training must be asset installation date, and second the asset decommission date
                    'features_for_training': [':installdate', ':estendoflife'],
                    'statistics_distribution_args': {
                        'distribution_type': 'WEIBULL',
                        'mean_or_scale': None,
                        'stddev_or_shape': None
                    }
                })
    df = group.execute()

    print(log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(df=df)
    # group.unregister()


if __name__ == '__main__':
    test()

