# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

"""
Contains functions used to make necessary changes in deployments when customers upgrade version. 
All functions should be documented and explain what versions they apply to.
"""

import logging
import os

from . import api

logger = logging.getLogger(__name__)


def update_monitor_catalog_functions():
    """
    Updates the input for all Predict catalog functions in the table IOTANALYTICS.CATALOG_FUNCTION 
    in the column INPUT. Changes to the input including adding the `incremental_summary` flag and 
    removing the extra `target_pipeline_name`.
    This function only needs to be called once after updating Predict.

    Applies to upgrading to any version newer than Predict 8.7.0 (Predict 8.7.1+, 8.8.0+).
    """

    logger.debug("Updating Monitor with latest model templates...")
    src_file = os.path.join(os.path.dirname(__file__), 'templates', 'catalog_function_input.json')

    with open(src_file, 'r') as f:
        new_input = f.read()

    sql = ("UPDATE IOTANALYTICS.CATALOG_FUNCTION " +
           f"SET INPUT='{new_input}' " +
           "WHERE NAME LIKE '%AssetGroupPipeline%';"
           )

    db = api._get_db()
    with db.connection.connect() as con:
        con.execute(sql)

    logger.debug('Finished updating database with new model templates.')
