# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pytest
import unittest
import os
from testbook import testbook

#https://testbook.readthedocs.io/en/latest/usage/index.htm

class EOL(unittest.TestCase):
    def setUp(self):
        
        self.NOTEBOOK_PATH_PREFIX = os.environ['NOTEBOOK_PATH_PREFIX']

    @pytest.mark.predict_fvt
    @pytest.mark.dependency(name="EOL_PMI_EOL", depends=['Data_Loader_FastStart'], scope='session')
    def test_EndToEndExecution(self):
        notebookPath = self.NOTEBOOK_PATH_PREFIX + 'PMI - End of Life Curve.ipynb'

        with testbook(notebookPath,execute=True,
                      timeout=1200) as tb:

            assert tb.cell_output_text('endFVT') != ''