# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pytest
import unittest
import os
from testbook import testbook

#https://testbook.readthedocs.io/en/latest/usage/index.htm

class Unsup_Training(unittest.TestCase):
    def setUp(self):     
        self.NOTEBOOK_PATH_PREFIX = os.environ['NOTEBOOK_PATH_PREFIX']
 
    @pytest.mark.predict_fvt
    @pytest.mark.dependency(name="AD_Explain_Unsup_Training", depends=['Data_Loader_FastStart','AD_WS_Unsup'], scope = 'session')
    def test_EndToEndExecution(self):
        notebookPath = self.NOTEBOOK_PATH_PREFIX + 'Explainable_Unsupervised_AnomalyDetection_Training.ipynb'
        with testbook(notebookPath,execute=slice('startFVT', 'endFVT'),timeout=21600) as tb:
            assert 'AnomalySaliencyExplainer' in tb.cell_output_text('verify_sample_exp')
            assert tb.cell_output_text('endFVT') != ''

class Unsup_Scoring(unittest.TestCase):
    def setUp(self):     
        self.NOTEBOOK_PATH_PREFIX = os.environ['NOTEBOOK_PATH_PREFIX']
    @pytest.mark.predict_fvt
    @pytest.mark.dependency(name="AD_Explain_Unsup_Scoring", depends=['AD_Explain_Unsup_Training'], scope = 'session')
    def test_EndToEndExecution(self):
        notebookPath = self.NOTEBOOK_PATH_PREFIX + 'Explainable_Unsupervised_AnomalyDetection_Scoring.ipynb'
        with testbook(notebookPath,execute=slice('startFVT', 'endFVT'),timeout=21600) as tb:
            assert tb.cell_output_text('endFVT') != ''

class Unsup_Results(unittest.TestCase):
    def setUp(self):     
        self.NOTEBOOK_PATH_PREFIX = os.environ['NOTEBOOK_PATH_PREFIX']
    @pytest.mark.predict_fvt
    @pytest.mark.dependency(name="AD_Explain_Unsup_Results", depends=['AD_Explain_Unsup_Scoring'], scope = 'session')
    def test_EndToEndExecution(self):
        notebookPath = self.NOTEBOOK_PATH_PREFIX + 'Explainable_Unsupervised_AnomalyDetection_Results.ipynb'
        with testbook(notebookPath,execute=slice('startFVT', 'endFVT'),timeout=21600) as tb:
            assert tb.cell_output_text('endFVT') != ''
