#!/bin/bash

BRANCH=$*
if [[ $# -eq 0 ]] ; then
    BRANCH=${TRAVIS_BRANCH}
fi

pwd
ls -la

if [[ "${BRANCH}" == "master" || "staging" ]]; then
#before_install:
   chmod +x build_doc.sh
   cp setup.py.saas setup.py

#install:
   pip install .[test]
   pip install pdoc3

#before_script:
   echo "${PMI_ARTIFACTORY_API_KEY}" | docker login -u "${PMI_ARTIFACTORY_USER}" --password-stdin iot-connectionservice-docker-local.artifactory.swg-devops.com
   docker build -f as-container/Dockerfile-travis -t pmlib/build .

#script:
   docker run --rm -it -e LOCAL_MODE=True pmlib/build
   python setup.py sdist
   /bin/bash build_doc.sh

	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib/pmlib-1.0.0-${TRAVIS_BRANCH}-${TRAVIS_BUILD_NUMBER}-saas.tar.gz" -T dist/pmlib-1.0.0.tar.gz
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib-doc/doc-${TRAVIS_BRANCH}-${TRAVIS_BUILD_NUMBER}-saas.zip" -T dist/doc.zip
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib/pmlib-1.0.0-${TRAVIS_BRANCH}-latest-saas.tar.gz" -T dist/pmlib-1.0.0.tar.gz
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib-doc/doc-${TRAVIS_BRANCH}-latest-saas.zip" -T dist/doc.zip

#checkin to APM-PM-Maven-Build repo:

#git clone --depth 5 -b master  --single-branch -c user.email=${GH_EMAIL} -c user.name=${GH_USER} ${GH_REPO} ${HOME}/${REPO}
#git clone --depth 5 -b ${BRANCH} --single-branch -c user.email=${GH_EMAIL} -c user.name=${GH_USER} ${GH_REPO} ${HOME}/${REPO}
#cp -f dist/pmlib-*.tar.gz ${HOME}/${REPO}/resource/dslib_saas/
#cp -f dist/doc.zip ${HOME}/${REPO}/resource/note_saas/
#cd ${HOME}/${REPO}
#git add resource/dslib_saas/* resource/note_saas/*
#git commit -m "Refreshed pmlib and pydoc on branch ${BRANCH}"
#git push "${GH_REPO}"  > /dev/null 2>&1

else
echo "ignore this branch"
fi

exit 0

done

