#!/bin/bash

BRANCH=$*
if [[ $# -eq 0 ]] ; then
    BRANCH=${TRAVIS_BRANCH}
fi

pwd
ls -la



if  [ "${BRANCH}" == "master" ]; then
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib/pmlib-1.0.0-${TRAVIS_BRANCH}-${TRAVIS_BUILD_NUMBER}.tar.gz" -T dist/pmlib-1.0.0.tar.gz
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib-doc/doc-${TRAVIS_BRANCH}-${TRAVIS_BUILD_NUMBER}.zip" -T dist/doc.zip
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib/pmlib-1.0.0-${TRAVIS_BRANCH}-latest.tar.gz" -T dist/pmlib-1.0.0.tar.gz
	curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib-doc/doc-${TRAVIS_BRANCH}-latest.zip" -T dist/doc.zip

elif  [ "${BRANCH}" == "staging" ]; then
        curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib/pmlib-1.0.0-${TRAVIS_BRANCH}-${TRAVIS_BUILD_NUMBER}.tar.gz" -T dist/pmlib-1.0.0.tar.gz
        curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib-doc/doc-${TRAVIS_BRANCH}-${TRAVIS_BUILD_NUMBER}.zip" -T dist/doc.zip
        curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib/pmlib-1.0.0-${TRAVIS_BRANCH}-latest.tar.gz" -T dist/pmlib-1.0.0.tar.gz
        curl -u ${PMI_ARTIFACTORY_USER}:${PMI_ARTIFACTORY_API_KEY} -X PUT "https://na.artifactory.swg-devops.com:443/artifactory/iot-maximo-apm-pmi-team-maven-local/com/ibm/pmq/ngp/pmlib-doc/doc-${TRAVIS_BRANCH}-latest.zip" -T dist/doc.zip

else
echo "ignore this branch"
fi

#exit 0

#done

pwd
ls -la

git clone --depth 5 -b ${BRANCH} --single-branch -c user.email=${GH_EMAIL} -c user.name=${GH_USER} ${GH_REPO} ${HOME}/${REPO}
cp -f dist/pmlib-*.tar.gz ${HOME}/${REPO}/resource/dslib/
cp -f dist/doc.zip ${HOME}/${REPO}/resource/note/
cd ${HOME}/${REPO}
git add resource/dslib/* resource/note/*
git commit -m "Refreshed pmlib and pydoc on branch ${BRANCH}"
git push "${GH_REPO}"  > /dev/null 2>&1


