#!/bin/bash
set -eu
IS_RELEASE=${TRAVIS_TAG+1}

export LOCAL_MODE="True"

die () { echo "ERROR: $*" >&2; exit 2; }

for cmd in pdoc3; do
    command -v "$cmd" >/dev/null ||
        die "Missing $cmd; \`pip install $cmd\`"
done

DOCROOT="."
BUILDROOT="$DOCROOT/docs"
ARCHIVE="dist/doc.zip"

pip install requests-futures
pip install pyarrow
pip install tabulate -q
pip install ibm-watsonx-ai==1.3.17 -q
pip install botocore -q
pip install xgboost -q
pip install tensorflow==2.18.1 -q
pip install scikeras==0.13.0 -q
pip install matplotlib
pip install ipynb_path
pip3 install dslib/srom-2.0.21.1.0-cp312-cp312-linux_x86_64.whl

echo
echo 'Building API reference docs'
echo
mkdir -p "$BUILDROOT"
rm -r "$BUILDROOT" 2>/dev/null || true
pdoc3 --html --force \
     ${IS_RELEASE+--template-dir "$DOCROOT/pdoc_template"} \
     --output-dir "$BUILDROOT" \
     pmlib
(rm -f "$ARCHIVE" && cd docs && zip -r ../"$ARCHIVE" pmlib/*)


echo
echo "All good. Docs in: $BUILDROOT"
echo
echo "    file://$BUILDROOT/pdoc/index.html"
echo
