This directory contains Docker build file for building images to develop and test locally.

It is not easy to install all the Python libraries in a local environment, be it Windows or Mac (Linux maybe the exception). To make it easier for local development, it is necessary to have a Docker image that is as close to AS runtime as possible. The Docker build files in this directory is for this purpose.

You might wonder why not just take AS images directly. The reason is that we aren't really able to have the full AS server side in this local development flow. A more practical way for development flow is to use pipelines as the running unit and being able to launch a pipeline directly in Docker containers without the need of AS server side.

By using an image that has all the libraries AS runtime provides, plus a few brought in by pmlib (becuase pmlib is local from your development workspace but not on-the-fly installed like in real AS runtime), we can just easily pick function/pipeline we want to test, locally.

> AS base image is published on ICS Artifactory repository. Check with AS team (rsiva@us.ibm.com) to get the access to their images.

To build an image based on AS production image:

```
docker build -f as-container/Dockerfile -t pmlib/production .
```

To build an image based on AS staging image:

```
docker build -f as-container/Dockerfile-staging -t pmlib/staging .
```

Naturally, you will need to modify the AS iamge tag in the Docker build files to match the latest one to be used.

> On top of AS base image, we only add `iotfunctions` and `grequests`. `iotfunctions` is AS's own Python library which AS installs on-the-fly each time its jobs launch hence it is not pre-installed in AS base image. `grequests` is `pmlib` own dependency which is also not pre-installed in AS base image. `grequests` is really an exception as we try to make sure all our dependencies, including SROM's dependencies, are pre-installed in AS base image.

All shell scripts use `pmlib/production`, so if testing staging, you need to modify the shell script used.

If you want to add more open source python libs such as sklearn-contrib-py-earth used by SROM, you can edit the Dockerfile as following:

RUN pip install sklearn-contrib-py-earth==0.1.0 --upgrade --no-cache


