#!/usr/bin/env python
#
# Licensed Materials - Property of IBM
# IBM Maximo APM - Predictive Maintenance Insights On-Premises
# IBM Maximo APM - Predictive Maintenance Insights SaaS
# IBM Maximo Application Suite
# © Copyright IBM Corp. 2019,2020 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

import os
import sys
from tempfile import mkstemp

from setuptools import setup, find_packages

if sys.version_info < (3,10):
    sys.exit('Python < 3.10 is not supported')

pmlibversion='9.1.3.dev564'

# to make managing the docker dev
# container a bit easier,
# write deps to a file
# for easy copy and pasting
FHANDLE, FNAME = mkstemp(prefix='pmlibdeps')
os.close(FHANDLE)
FILE = open(FNAME, 'w')
path_to_my_project=os.path.join(os.getcwd())+"/dslib"
INSTALL_REQUIRES = [
    
    
    
    'requests-futures==1.0.0',
    'ibm_db_sa==0.4.1',
    'ibm_db==3.2.3',
    'sqlalchemy==2.0.36',   
    
    'numpy==1.26.4',            
	'pandas==2.1.4',
    'protobuf==4.21.12',
	'requests==2.32.4',
	'scikit-learn==1.3.0',
	'scipy==1.11.4',
    'joblib==1.3.2',
    'xgboost==2.0.3',
    'dill==0.3.7',
    'scikeras==0.12.0',
    'pyspark==3.4.0',
    'transformers==4.48.0',
    'pytz',
    

    # install tensorflow==2.7.3 in the notebook, not in the pmlib because it will fail in the WML deployment
    # tensorflow has 495.6 MB 
    #'tensorflow==2.7.3',

    f"srom @ file://localhost/{path_to_my_project}/srom-2.0.20.1.0-cp311-cp311-linux_x86_64.whl",
    f"dqlearn @ file://localhost/{path_to_my_project}/dqlearn-0.7.2.1.0-cp311-cp311-linux_x86_64.whl",

    #f"watson-data-client @ file://localhost/{path_to_my_project}/watson_data_client-1.0.2-cp310-cp310-linux_x86_64.whl",
    #f"mat-sdk @ file://localhost/{path_to_my_project}/mat-sdk-0.31.2.zip",
    

    #comment out to build srom
    f"aixclient @ file://localhost/{path_to_my_project}/aixclient-1.7.7.zip",

    #Kewei needs to put it back
    #f"modelfactory @ file://localhost/{path_to_my_project}/modelfactory-1.0.17.1.0-cp310-cp310-linux_x86_64.whl",
    
   
    

    #f"watsondataclient @ file://localhost/{path_to_my_project}/watson_data_client-0.0.3.tar.gz",
    #f"matsdk @ file://localhost/{path_to_my_project}/mat-sdk-0.27.1.tar.gz",

    #f"watson-data-client @ file://localhost/{path_to_my_project}/watson_data_client-0.0.3.zip",
    #f"mat-sdk @ file://localhost/{path_to_my_project}/matsdk.zip",

    
    
    
    
    #'tsfresh==0.17.0',
    
    #'tensorflow==2.7.0',
    
    #'watson-machine-learning-client~=1.0.371',

    # still mandatory by srom <1.2.0, TODO remove once upgraded to 1.2.0+
    #'matplotlib==3.3.4',

    # used by iotfunctions_3_0 but not specified by it
    #'pyarrow==3.0.0',
    #"statsmodels==0.13.2",
    #"tqdm==4.10.0",
    #"decorator==4.3.0",
    #"python-dateutil==2.8.1",
    #"future==0.16.0",
    #"idna==2.5",
    #"certifi==2017.4.17"
    "pip >= 24.0"
]

EXTRA_REQUIRES = {
    'test': [
        'pytest',
        'pytest-mock',
        'pytest-cov',
       # 'pmlb',
       # 'pwlf',
       # 'ipython',
       # 'graphviz',
        #'plotly==4.8.2',
    ],
   
  
   

}

EVERYTHING = INSTALL_REQUIRES.copy()
for val in EXTRA_REQUIRES.values():
    EVERYTHING.extend(val)

for item in EVERYTHING[0:-1]:
    FILE.write('"{}" \\ \n'.format(item))
FILE.write('"{}"\n'.format(EVERYTHING[-1]))
FILE.close()
print('dependency list file is {}'.format(FNAME))

setup(
    name='pmlib',
    version=pmlibversion,
    author='ibm',
    author_email='mhtsai@cn.ibm.com',
    url='https://www.ibm.com/',
    description='IBM Maximo APM Predictive Maintenance Insights SDK.',
    packages=find_packages(exclude=("tests",)),
    package_dir = {
        'iotfunctions': 'iotfunctions',
    },   
    package_data={
        'pmlib': ['**/*.csv'],
    },
    data_files=[
        ('templates', ['pmlib/templates/catalog_function_input.json'])
    ],
    include_package_data=True,
    install_requires=INSTALL_REQUIRES,
    extras_require=EXTRA_REQUIRES,
    zip_safe=True
)
