# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

from ..anomaly_detection import AnomalyDetectionAssetGroupPipeline


def test_model_template_name():
    # a custom derived from OOTB can use their own desired template name
    class Custom(AnomalyDetectionAssetGroupPipeline):
        def __init__(self, **kwargs):
            super().__init__(model_template_name='Custom Name Given', **kwargs)

    c1 = Custom(asset_group_id='1', model_pipeline={'features': [':faildate'], 'predictions': ['abc']})
    assert c1.model_template_name == 'Custom Name Given'
    assert c1.model_template_desc == 'Custom Name Given'

    # a custom derived from OOTB can use their own desired template name and description
    class Custom(AnomalyDetectionAssetGroupPipeline):
        def __init__(self, **kwargs):
            super().__init__(model_template_name='Custom Name Given', model_template_desc='Custom Description Given', **kwargs)

    c1 = Custom(asset_group_id='1', model_pipeline={'features': [':faildate'], 'predictions': ['abc']})
    assert c1.model_template_name == 'Custom Name Given'
    assert c1.model_template_desc == 'Custom Description Given'

    # a custom derived from OOTB if not given its desired template name, the class name is used instead by default
    class Custom(AnomalyDetectionAssetGroupPipeline):
        pass

    c2 = Custom(asset_group_id='1', model_pipeline={'features': [':faildate'], 'predictions': ['abc']})
    assert c2.model_template_name == Custom.__name__
    assert c2.model_template_desc == Custom.__name__

