# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

from iotfunctions.base import BasePreload

from . import api
from .util import get_logger, get_as_schema


class AssetCacheRefresher(BasePreload):

    def __init__(self, asset_group, data_items=None, include_asset_data=False, db=None, db_schema=None):
        super().__init__('dummy_items')
        self.logger = get_logger(self)

        db_schema = get_as_schema(db_schema)
        self.asset_group = asset_group
        self.data_items = data_items
        self.include_asset_data = include_asset_data

        self.db = db
        self.db_schema = db_schema
        
    def execute(self, df=None, start_ts=None, end_ts=None, entities=None):
        '''Run to refresh the asset cache.

        The asset cache includes asset group members, asset device mappings, and asset data.

        Note that df is always given as None.
        '''

        self.logger.info('Refreshing asset cache with data from Maximo and Monitor to update Predict database.')
        self.logger.debug('Args: start_ts=%s, end_ts=%s, entities=%s', start_ts, end_ts, entities)

        api._refresh_asset_cache(self.asset_group, db=self.db, db_schema=self.db_schema, start_ts=start_ts, end_ts=end_ts, data_items=self.data_items, include_asset_data=self.include_asset_data)

        return True

