# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

"""IBM Maximo Application Suite Predict Python SDK.

## Installation

Install with pip:

```
import os
os.environ['TRUST_PREDICT']= os.getenv('APM_API_BASEURL')[8:]
print(os.getenv('TRUST_PREDICT'))



#pip install --trusted-host ${TRUST_PREDICT}  -U ${APM_API_BASEURL}/ibm/pmi/service/rest/ds/${APM_ID}/${APM_API_KEY}/lib/download?filename=pmlib-1.0.0.tar.gz
pip install --trusted-host ${TRUST_PREDICT}  -U ${APM_API_BASEURL}/ibm/pmi/service/rest/ds/${APM_ID}/${APM_API_KEY}/lib/download?filename=pmlib

```

The Python SDK is hosted on Maximo Application Suite Predict server protected by API key. You shall be able to find your APM_API_BBASEURL, APM_ID, and APM_API_KEY in the "Getting credentials" link in
* [IBM Knowledge Center](https://www-03preprod.ibm.com/support/knowledgecenter/SSLPYA_current/com.ibm.pre.doc/welcome_pre.html)

## Uninstallation

Uninstalling the Python SDK is simple:

```
pip uninstall -y pmlib
```

## Additional Documentation

* [IBM Knowledge Center](https://www-03preprod.ibm.com/support/knowledgecenter/SSLPYA_current/com.ibm.pre.doc/welcome_pre.html)

"""

__version__ = '8.8.0'

__pdoc__ = {
    'cache_loader': False,
    'loader': False,
    'persist': False,
    'tests': False,
}

# alias

from .api import *
from .anomaly_detection import AnomalyDetectionAssetGroupPipeline
from .degradation_curve import DegradationCurveAssetGroupPipeline
from .failure_prediction import FailurePredictionAssetGroupPipeline
from .time_to_failure import TimeToFailureAssetGroupPipeline
from .pipeline import AssetGroupPipeline, SimpleCustomAssetGroupPipelineLoader, WmlScoringAssetGroupPipeline
from .util import *

util.setup_logging()