from setuptools import setup, find_packages
from shutil import copy

copy("VERSION", "aiexpts/VERSION")
aixclient_version = open("VERSION").read()

# with open("aiexpts/__init__.py", 'w') as fp:
#     fp.writelines(["__version__ = \"{}\"".format(aixclient_version)])

setup(
    name="aixclient",
    version=aixclient_version,
    description="AI Explainability Client SDK For TimeSeries Applications",
    url="www.ibm.com",
    author="Giridhar Ganapavarapu",
    author_email="giridhar.ganapavarapu@ibm.com",
    license="IBM",
    packages=find_packages(),
    data_files=[("aiexpts", ["aiexpts/VERSION"]), ("", ["VERSION"])],
    include_package_data=True,
    package_data={"aiexpts": ["aiexpts/VERSION"]},
    python_requires=">=3.11",
    install_requires=[
        "pandas==2.1.4",  # previously 1.4.3
        "numpy==1.26.4",  # previously 1.23.1
        "aiohttp==3.12.14",  # previously 3.9.5
        "nest_asyncio==1.5.5",
        "requests==2.32.4",  # previosly 2.31.0
        "plotly==5.19.0",  # previously 5.4.0,
        "shap==0.46.0",
        "certifi==2024.8.30",  # previously 2024.07.04
    ],
    zip_safe=False,
)
