#!/usr/bin/env python
#
# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import os
import sys
from tempfile import mkstemp

from setuptools import setup, find_packages

if sys.version_info < (3,10):
    sys.exit('Python < 3.10 is not supported')

pmlibversion='9.0'

# to make managing the docker dev
# container a bit easier,
# write deps to a file
# for easy copy and pasting
FHANDLE, FNAME = mkstemp(prefix='pmlibdeps')
os.close(FHANDLE)
FILE = open(FNAME, 'w')
path_to_my_project=os.path.join(os.getcwd())+"/dslib"
INSTALL_REQUIRES = [
    
    'requests-futures==1.0.0',
    'ibm_db_sa==0.4.1',
    'ibm_db==3.2.6',
    'sqlalchemy==2.0.36',   
    'ibm-watsonx-ai==1.3.17',
    'numpy==2.0.2',            
	'pandas==2.2.3',
    'protobuf==4.25.3',
	'requests==2.32.4',
	'scikit-learn==1.6.1',
	'scipy==1.15.2',
    'joblib==1.4.2',
    'xgboost==2.1.4',
    'dill==0.3.9',
    'scikeras==0.13.0',
    'transformers==4.48.0',
    'aiohttp==3.12.14',
    'pytz',
    




    # #required by iotfunctions
    # 'lxml==4.9.1',
    # 'ibm_db_sa==0.3.8',
    # 'ibm_db==3.1.2',    
    # 'nose2==0.6.0',
    # 'psycopg2-binary==2.8.6',
    # 'pyarrow==5.0.0',
    # 'pyod==1.0.0',
    # 'ruptures==1.1.5',
    # 'scikit-image==0.18.3',
    # 'statsmodels==0.12.2',
    # 'stumpy==1.9.2',
    # 'tabulate==0.8.9',
    # 'torch==1.10.2',
    # 'scipy==1.7.3',
    
    f"srom @ file://localhost/{path_to_my_project}/srom-2.0.21.1.0-cp312-cp312-linux_x86_64.whl",
    f"dqlearn @ file://localhost/{path_to_my_project}/dqlearn-0.7.4.1.0-cp312-cp312-linux_x86_64.whl",

    #f"watson-data-client @ file://localhost/{path_to_my_project}/watson_data_client-1.0.2-cp310-cp310-linux_x86_64.whl",
    #f"mat-sdk @ file://localhost/{path_to_my_project}/mat-sdk-0.31.2.zip",
    
    #Kewei comment out explainability to install srom
  
    f"aixclient @ file://localhost/{path_to_my_project}/aixclient-1.7.11.zip",

    #Kewei needs to put it back
    #f"modelfactory @ file://localhost/{path_to_my_project}/modelfactory-1.0.17.1.0-cp310-cp310-linux_x86_64.whl",
    
    # Kewei remove the aixclient to fix the pip install issue.
    #f"aixclient @ file://localhost/{path_to_my_project}/aixclient.zip",
    #'iotfunctions@https://github.com/ibm-watson-iot/functions/tarball/production',
    #'iotfunctions@https://github.com/ibm-watson-iot/functions/tarball/apm_debug',
    
    #'tsfresh==0.17.0',
    
    #'tensorflow==2.7.0',
    
    #'watson-machine-learning-client~=1.0.371',

    # still mandatory by srom <1.2.0, TODO remove once upgraded to 1.2.0+
    #'matplotlib==3.3.4',

    # used by iotfunctions_3_0 but not specified by it
    #'pyarrow==3.0.0',
    #"statsmodels==0.13.2",
    #"tqdm==4.10.0",
    #"decorator==4.3.0",
    #"python-dateutil==2.8.1",
    #"future==0.16.0",
    #"idna==2.5",
    #"certifi==2017.4.17"
    "pip >= 24.0"
]

EXTRA_REQUIRES = {
    'test': [
        'pytest',
        'pytest-mock',
        'pytest-cov',
       # 'pmlb',
       # 'pwlf',
       # 'ipython',
       # 'graphviz',
        #'plotly==4.8.2',
    ],
   
  
   

}

EVERYTHING = INSTALL_REQUIRES.copy()
for val in EXTRA_REQUIRES.values():
    EVERYTHING.extend(val)

for item in EVERYTHING[0:-1]:
    FILE.write('"{}" \\ \n'.format(item))
FILE.write('"{}"\n'.format(EVERYTHING[-1]))
FILE.close()
print('dependency list file is {}'.format(FNAME))

setup(
    name='pmlib',
    version=pmlibversion,
    author='ibm',
    author_email='mhtsai@cn.ibm.com',
    url='https://www.ibm.com/',
    description='IBM Maximo APM Predictive Maintenance Insights SDK.',
    packages=find_packages(exclude=("tests",)),
    package_dir = {
        'iotfunctions': 'iotfunctions',
    },
    package_data={
        'pmlib': ['**/*.csv'],
    },
    data_files=[
        ('templates', ['pmlib/templates/catalog_function_input.json'])
    ],
    include_package_data=True,
    install_requires=INSTALL_REQUIRES,
    extras_require=EXTRA_REQUIRES,

    zip_safe=True
)
