# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

def test():
    from ..api import get_maximo_asset_group_id
    from ..time_to_failure import TimeToFailureAssetGroupPipeline
    from ..util import log_df_info


    #TimeToFailureAssetGroupPipeline.generate_sample_data(sensor_type_name='IntgFailureSensor', site_id='BEDFORD')
    #needs to take 1016 as a parameter
    asset_device_mappings={'INTAT_%04d-____-BEDFORD' % i: ['IntgFailureSensor:INTAT_%04d_SENSOR_00' % i] for i in range(0,10)}
    group = TimeToFailureAssetGroupPipeline(
                asset_group_id=get_maximo_asset_group_id('INTGGROUP'),
                model_pipeline={
                    'features': ['IntgFailureSensor:sensor_1', 'IntgFailureSensor:sensor_2', 'IntgFailureSensor:sensor_3'],
                    'features_for_training': [':installdate', ':faildate'],
                    'predictions': ['predicted_time_to_failure'],
                },
                asset_device_mappings=asset_device_mappings)
    df = group.execute()

    print(log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(df=df)

    # group.unregister()


if __name__ == '__main__':
    test()

