# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

def test():
    from ..api import get_maximo_asset_group_id
    from ..time_to_failure import TimeToFailureAssetGroupPipeline
    from ..util import log_df_info


    asset_device_mappings={'INTGTST0000-____-BEDFORD': ['TravisSensorType:Travis0_SENSOR_00'], 'INTGTST0001-____-BEDFORD': ['TravisSensorType:Travis1_SENSOR_00'], 'INTGTST0002-____-BEDFORD': ['TravisSensorType:Travis2_SENSOR_00'], 'INTGTST0003-____-BEDFORD': ['TravisSensorType:Travis3_SENSOR_00'], 'INTGTST0004-____-BEDFORD': ['TravisSensorType:Travis4_SENSOR_00'], 'INTGTST0005-____-BEDFORD': ['TravisSensorType:Travis5_SENSOR_00'], 'INTGTST0006-____-BEDFORD': ['TravisSensorType:Travis6_SENSOR_00'], 'INTGTST0007-____-BEDFORD': ['TravisSensorType:Travis7_SENSOR_00'], 'INTGTST0008-____-BEDFORD': ['TravisSensorType:Travis8_SENSOR_00'], 'INTGTST0009-____-BEDFORD': ['TravisSensorType:Travis9_SENSOR_00']}

    group = TimeToFailureAssetGroupPipeline(
                asset_group_id=get_maximo_asset_group_id('INTGGROUPTRV'),
                model_pipeline={
                    'features': ['TravisSensorType:sensor_1', 'TravisSensorType:sensor_2', 'TravisSensorType:sensor_3', 'TravisSensorType:sensor_4', 'TravisSensorType:sensor_5', 'TravisSensorType:sensor_6', 'TravisSensorType:sensor_7', 'TravisSensorType:sensor_8', 'TravisSensorType:sensor_9', 'TravisSensorType:sensor_10', 'TravisSensorType:sensor_11', 'TravisSensorType:sensor_12', 'TravisSensorType:sensor_13', 'TravisSensorType:sensor_14', 'TravisSensorType:sensor_15', 'TravisSensorType:sensor_16', 'TravisSensorType:sensor_17', 'TravisSensorType:sensor_18', 'TravisSensorType:sensor_19', 'TravisSensorType:sensor_20', 'TravisSensorType:sensor_21', 'TravisSensorType:sensor_22', 'TravisSensorType:sensor_23', 'TravisSensorType:sensor_24', 'TravisSensorType:sensor_25', 'TravisSensorType:sensor_26', 'TravisSensorType:sensor_27', 'TravisSensorType:sensor_28', 'TravisSensorType:sensor_29', 'TravisSensorType:sensor_30', 'TravisSensorType:sensor_31', 'TravisSensorType:sensor_32', 'TravisSensorType:sensor_33', 'TravisSensorType:sensor_34', 'TravisSensorType:sensor_35', 'TravisSensorType:sensor_36', 'TravisSensorType:sensor_37', 'TravisSensorType:sensor_38', 'TravisSensorType:sensor_39', 'TravisSensorType:sensor_40', 'TravisSensorType:sensor_41'],
                    'features_for_training': [':installdate', ':faildate'],
                    'predictions': ['predicted_time_to_failure'],
                },
                asset_device_mappings=asset_device_mappings)
    df = group.execute()

    print(log_df_info(df, head=0))


if __name__ == '__main__':
    test()

