# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib


def test():
    asset_group_id='9999'

    group = pmlib.DegradationCurveAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features_for_training': [':installdate', ':estendoflife'],
                    'statistics_distribution_args': {
                        'distribution_type': 'WEIBULL',
                        'mean_or_scale': None,
                        'stddev_or_shape': None
                    }
                })
                # },
                # model_timestamp={'FailurePredictionEstimator': '1563443859', 'FailurePredictionRcaEstimator': '1563443861'})
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(url = 'git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git')
    # group.unregister()


if __name__ == '__main__':
    test()

