# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib
from sklearn.preprocessing import StandardScaler, RobustScaler, MinMaxScaler
from sklearn.ensemble import IsolationForest
'''from sklearn.covariance import (EmpiricalCovariance, EllipticEnvelope, LedoitWolf, MinCovDet, OAS, ShrunkCovariance)
from sklearn.mixture import GaussianMixture, BayesianGaussianMixture
from sklearn.svm import OneClassSVM

from srom.anomaly_detection.algorithms import NearestNeighborAnomalyModel, LOFNearestNeighborAnomalyModel
from srom.anomaly_detection.algorithms.srom_pca_Q import AnomalyPCA_Q
from srom.anomaly_detection.algorithms.srom_pca_T2 import AnomalyPCA_T2
from srom.anomaly_detection.gaussian_graphical_anomaly_model import GaussianGraphicalModel'''
from srom.anomaly_detection.generalized_anomaly_model import GeneralizedAnomalyModel
from srom.utils.no_op import NoOp


def test(asset_group_id='9999'):
    group = pmlib.AnomalyDetectionAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features': ['TrainBrakeSensor:axlevibration', 'TrainBrakeSensor:axlemomentum'],
                    'features_for_training': [':faildate'],
                    'predictions': ['anomaly_score', 'anomaly_threshold'],
                    'srom_training_options': {
                        'exectype': 'single_node_random_search'
                    },
                    'override_training_stages': [
                        [
                            ('skipscaling', NoOp()), 
                            ('standardscaler', StandardScaler()),
                            ('robustscaler', RobustScaler()), 
                            ('minmaxscaling', MinMaxScaler())
                        ],
                        [
                            # Rule/Density based Anomaly Models
                            ('isolationforest', GeneralizedAnomalyModel(base_learner=IsolationForest(), predict_function='decision_function', score_sign=-1)), 
                            # ('gaussianmixture', GeneralizedAnomalyModel(base_learner=GaussianMixture(), predict_function='score_samples', score_sign=1)),
                            # ('bayesiangaussianmixture', GeneralizedAnomalyModel(base_learner=BayesianGaussianMixture(), predict_function='score_samples', score_sign=1)), 
                            # ('oneclasssvm', GeneralizedAnomalyModel(base_learner=OneClassSVM(), predict_function='decision_function', score_sign=1)), 
                            # ('nearestneighboranomalymodel', GeneralizedAnomalyModel(base_learner=NearestNeighborAnomalyModel(), predict_function='predict', score_sign=1)), 
                            # ('lofnearestneighboranomalymodel', GeneralizedAnomalyModel(base_learner=LOFNearestNeighborAnomalyModel(), predict_function='predict', score_sign=1)),
                            # ('anomalypca_t2', GeneralizedAnomalyModel(base_learner=AnomalyPCA_T2(), predict_function='anomaly_score',score_sign=1)), 
                            # ('anomalypca_q', GeneralizedAnomalyModel(base_learner=AnomalyPCA_Q(), predict_function='anomaly_score',score_sign=1)),

                            # # Covariance Structure based Anomaly Models
                            # ('empiricalcovariance', GeneralizedAnomalyModel(base_learner=EmpiricalCovariance(), fit_function='fit', predict_function='mahalanobis',score_sign=1)), 
                            # ('ellipticenvelope', GeneralizedAnomalyModel(base_learner=EllipticEnvelope(), fit_function='fit', predict_function='mahalanobis',score_sign=1)),
                            # ('ledoitwolf', GeneralizedAnomalyModel(base_learner=LedoitWolf(), fit_function='fit', predict_function='mahalanobis',score_sign=1)), 
                            # ('mincovdet', GeneralizedAnomalyModel(base_learner=MinCovDet(), fit_function='fit', predict_function='mahalanobis',score_sign=1)), 
                            # ('oas', GeneralizedAnomalyModel(base_learner=OAS(), fit_function='fit', predict_function='mahalanobis',score_sign=1)), 
                            # ('shrunkcovariance', GeneralizedAnomalyModel(base_learner=ShrunkCovariance(), fit_function='fit', predict_function='mahalanobis',score_sign=1)),

                            # # GaussianGraphicalModel
                            # ('ggm_default', GaussianGraphicalModel()), 
                            # ('ggm_stochastic', GaussianGraphicalModel(distance_metric='Stochastic_Nearest_Neighbors')),
                            # ('ggm_kldiverse', GaussianGraphicalModel(distance_metric='KL_Divergence_Dist')), 
                            # ('ggm_frobenius', GaussianGraphicalModel(distance_metric='Frobenius_Norm')),
                            # ('ggm_likelihood', GaussianGraphicalModel(distance_metric='Likelihood')), 
                            # ('ggm_spectral', GaussianGraphicalModel(distance_metric='Spectral')),
                            # ('ggm_mahalanobis_distance', GaussianGraphicalModel(distance_metric='Mahalanobis_Distance')),
                            # ('ggm_sparsest_k_subgraph', GaussianGraphicalModel(distance_metric='Sparsest_k_Subgraph'))
                        ]
                    ]
                })
                
                # },
                # model_timestamp={'FailurePredictionEstimator': '1563443859', 'FailurePredictionRcaEstimator': '1563443861'})
    df = group.execute()

    # Once all are ready, register the function and create a KPI
    group.register(url = 'git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git')
    # group.unregister()


if __name__ == '__main__':
    test()

