# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

'''
This test script uses 1 asset, PMI_ASSET111, and 1 sensor, sample_sensor111 of device type SampleFailureSensor, to train the failure probability model.

It loads from 'data.csv' the 3 sensor data (sensor_1, sensor_2, sensor_3) as well as extracting the asset failure history. The data file contains a flag indicating failure event.
'''

def test():
    import argparse
    from ..api import get_maximo_asset_group_id
    from ..failure_prediction import FailurePredictionAssetGroupPipeline
    from ..util import log_df_info

    parser = argparse.ArgumentParser()
    parser.add_argument('--option', help='Pass the action you want to execute')
    parser.add_argument('--asset_group_name', help='Asset Group Id')
    parser.add_argument('--asset_query', help="Asset query name")
    parser.add_argument('--sensor_type_name', help='Pass the Sensor Type ( WIoTP Device Type )')
    parser.add_argument('--sensor_id_prefix', help='Pass the prefix of the Sensor Id (WIoTP Device Id)')
    parser.add_argument('--extra_option', help='Extra option used by the WIoTP Simulator')
    parser.add_argument('--site_id', help='Asset Site Id')
    parser.add_argument('--asset_num_prefix', help='Asset Num Prefix')
    parser.add_argument('--asset_start_num', help='Asset Start Num')
    parser.add_argument('--asset_total', help='Number of Assets')
    parser.add_argument('--model', help="Predictive Model")
    parser.add_argument('--env', help="Target Environment")
    args = parser.parse_args()

    features = []
    for i in range(1,4):
        features.append(args.sensor_type_name+":sensor_"+str(i))

    asset_device_mappings = {'%s%04d-____-%s' % (args.asset_num_prefix, i, args.site_id): ['%s:%s%1d_SENSOR_00' % (args.sensor_type_name, args.sensor_id_prefix, i)] for i in range(int(args.asset_start_num), (int(args.asset_total) - 1))}
    # FailurePredictionAssetGroupPipeline.generate_sample_data(sensor_type_name=args.sensor_type_name, sensor_id_prefix=args.sensor_id_prefix, site_id=args.site_id, asset_num_prefix=args.asset_num_prefix, asset_start_num=args.asset_start_num, asset_total=args.asset_total)

    group = FailurePredictionAssetGroupPipeline(
                asset_group_id=get_maximo_asset_group_id(args.asset_group_name), 
                model_pipeline={
                    'features': features,
                    'features_for_training': [':faildate'],
                    'predictions': ['failure_probability_30d', 'rca_path_30d'],
                    'aggregation_methods': ['mean', 'max', 'min', 'median', 'std', 'sum', 'count'],
                    'prediction_window_size': '30d',
                },
                asset_device_mappings=asset_device_mappings)

    df = group.execute()

    print(log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    # group.register(df=df)
    # group.unregister()


if __name__ == '__main__':
    test()

