# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

def test():
    from ..anomaly_detection import AnomalyDetectionAssetGroupPipeline
    from ..util import log_df_info
    from ..api import get_maximo_asset_group_id
    import time

    '''
    This test script uses 3 assets, PMI_ASSET101 through PMI_ASSET103, and 3 sensors, sample_sensor101 through sample_sensor103 of device type SampleAnomalySensor, to train the anomaly detection model.

    It loads from 'trainX.csv' and 'validXy.csv' 42 sensor data (x1 through x42) as well as extracting the asset failure history. The data file 'validXy' contains a flag indicating failure event.
    '''

    asset_group_id = get_maximo_asset_group_id('INTGGROUP')
    sensor_type_name = 'IntgFailureSensor'
    sensor_id_prefix = 'INTAT_000'
    site_id = 'BEDFORD'
    asset_num_prefix = 'INTAT_000'
    asset_start_num = 0
    asset_num = 10


    asset_device_mappings = AnomalyDetectionAssetGroupPipeline.generate_sample_data(sensor_type_name=sensor_type_name, sensor_id_prefix=sensor_id_prefix, site_id=site_id, asset_num_prefix=asset_num_prefix, asset_start_num=asset_start_num, asset_num=asset_num)
    #asset_device_mappings = {'INTAT_%04d-____-BEDFORD' % i: ['IntgFailureSensor:INTAT_%04d_SENSOR_00' % i] for i in range(0,3)}
    print("asset_device_mappings")
    print(asset_device_mappings)
    print("\n\n\n\n")
    time.sleep(3)



    group = AnomalyDetectionAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features': ['IntgFailureSensor:sensor_1', 'IntgFailureSensor:sensor_2', 'IntgFailureSensor:sensor_3',
                                 'IntgFailureSensor:sensor_4', 'IntgFailureSensor:sensor_5', 'IntgFailureSensor:sensor_6',
                                 'IntgFailureSensor:sensor_7', 'IntgFailureSensor:sensor_8', 'IntgFailureSensor:sensor_9',
                                 'IntgFailureSensor:sensor_10'],
                    'features_for_training': [':faildate'],
                    'predictions': ['anomaly_score', 'anomaly_threshold'],
                    'srom_training_options': {
                        'exectype': 'single_node_random_search'
                    }
                },
                asset_device_mappings=asset_device_mappings)
    #group.set_asset_device_mappings(asset_device_mappings)
    #group.set_asset_device_mappings({'INTAT_%04d-____-BEDFORD' % i: ['IntgFailureSensor:INTAT_%04d_SENSOR_00' % i] for i in range(0,3)})
    df = group.execute()

    print(log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(df=df)
    # group.unregister()


if __name__ == '__main__':
    test()

