# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

class BaseExplainer:
    def __init__(self,**param):
        self.config_options = param
    def get_explainability_service(self):
        from aiexpts.client import AIXTSClient
        service_endpoint = self.config_options['explainability_service']['service_endpoint']
        service_port = self.config_options['explainability_service'].get('service_port',None)
        if service_port == 'None':
            service_port = None
        service_auth_data = self.config_options['explainability_service'].get('service_auth_data',None)
        print(f'service_auth_data={service_auth_data}')
        exp_client = AIXTSClient(service_endpoint, port=service_port, auth=service_auth_data)
        return exp_client
