# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pytest
import unittest
import os
import json
from testbook import testbook

#https://testbook.readthedocs.io/en/latest/usage/index.htm

class EOL(unittest.TestCase):
    
    def setUp(self):
        
        self.NOTEBOOK_PATH_PREFIX = os.environ['NOTEBOOK_PATH_PREFIX']

    @pytest.mark.predict_fvt
    def test_EndToEndExecution(self): 
        notebookPath = self.NOTEBOOK_PATH_PREFIX + 'WS - End of Life Curve.ipynb' 
        with testbook(notebookPath,execute=slice('startFVT', 'endFVT'),timeout=2400) as tb:
            assert tb.cell_output_text('endFVT') != ''   
