# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pandas as pd
import numpy as np

from sklearn.preprocessing import StandardScaler, RobustScaler, MinMaxScaler
from sklearn.pipeline import Pipeline
from sklearn.model_selection import GridSearchCV, RandomizedSearchCV

import pyod
from pyod.models.abod import ABOD
from pyod.models.cof import COF
from pyod.models.hbos import HBOS
from pyod.models.sod import SOD
from pyod.models.ocsvm import OCSVM
from pyod.models.sos import SOS
import PyNomaly
from PyNomaly import loop

from pmlib.estimator import BaseEstimator, WmlDeploymentEstimator
from pmlib.pipeline import AssetGroupPipeline


from pmlib.anomaly_detection import AnomalyDetectionEstimator, AnomalyDetectionAssetGroupPipeline

class CustomUnsupervisedAnomalyDetectionEstimator(AnomalyDetectionEstimator):
    
    def get_stages(self):        

         return [
            [
                ('ss', StandardScaler()),
                ('rs', RobustScaler()), 
                ('mms', MinMaxScaler())
            ],
            [
                ('abod', ABOD()),  # for high dimensional feature space
                ('cof', COF()),
                ('sos', SOS()),  
                ('hbos', HBOS()),
                ('ocsvm', OCSVM()),
                ('sod', SOD())
            ]
        ]
    
class CustomUnsupervisedAnomalyDetectionAssetGroupPipeline(AnomalyDetectionAssetGroupPipeline):
    pass