/*
 * Decompiled with CFR 0.152.
 */
package custom.idz;

import custom.idz.PliLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;

public class PliNot {
    PrintStream log = null;
    boolean debug = false;

    public static void main(String[] args) {
        PliNot task = new PliNot();
        task.execute(args);
    }

    private void execute(String[] args) {
        OutputStreamWriter writer = null;
        BufferedReader reader = null;
        try {
            try {
                if (args.length < 2) {
                    System.err.println("command line error, too few arguments. Usage is arg1=input file, arg2=output file, arg3=log file (optional)");
                    System.exit(-1);
                }
                if (args.length == 3) {
                    this.log = new PrintStream(args[2]);
                    this.debug = true;
                }
                this.log("JAVA PREPROCESSOR start");
                this.log("reading from " + args[0]);
                this.log("writing to " + args[1]);
                File in = new File(args[0]);
                File out = new File(args[1]);
                if (in.exists()) {
                    String strLine;
                    writer = null;
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), Charset.forName("UTF-8").newDecoder()));
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), Charset.forName("UTF-8").newEncoder());
                    while ((strLine = reader.readLine()) != null) {
                        this.log("read line=" + strLine);
                        strLine = PliNot.fixPli(strLine);
                        this.log("write line=" + strLine);
                        writer.write(strLine);
                        writer.write("\n");
                    }
                    writer.flush();
                    this.log("JAVA PREPROCESSOR end");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    if (this.log != null) {
                        this.log.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    if (this.log != null) {
                        this.log.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (this.log != null) {
                    this.log.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String fixPli(String strLine) {
        PliLine srcLine = new PliLine(strLine);
        return srcLine.fixPliNot();
    }

    private void log(String msg) {
        if (this.debug) {
            this.log.println(msg);
        }
    }
}

