#!/usr/bin/perl

use Getopt::Std;

$USER = "ADMIN";
$PW = "ADMIN";
$IP = "";
$CHUNK = 254.0;

%rawSize = ( 
	"gard",  "raw 0x3a 0x0c 0x47 0x55 0x41 0x52 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"hbel",  "raw 0x3a 0x0c 0x48 0x42 0x45 0x4c 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"fir",   "raw 0x3a 0x0c 0x46 0x49 0x52 0x44 0x41 0x54 0x41 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"attrp", "raw 0x3a 0x0c 0x41 0x54 0x54 0x52 0x5f 0x50 0x45 0x52 0x4d 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"attrt", "raw 0x3a 0x0c 0x41 0x54 0x54 0x52 0x5f 0x54 0x4d 0x50 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"ver",   "raw 0x3a 0x0c 0x56 0x45 0x52 0x53 0x49 0x4f 0x4e 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
);

%rawData = ( 
	"gard",  "raw 0x3a 0x0b 0x47 0x55 0x41 0x52 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"hbel",  "raw 0x3a 0x0b 0x48 0x42 0x45 0x4c 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"fir",   "raw 0x3a 0x0b 0x46 0x49 0x52 0x44 0x41 0x54 0x41 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"attrp", "raw 0x3a 0x0b 0x41 0x54 0x54 0x52 0x5f 0x50 0x45 0x52 0x4d 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"attrt", "raw 0x3a 0x0b 0x41 0x54 0x54 0x52 0x5f 0x54 0x4d 0x50 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
	"ver",   "raw 0x3a 0x0b 0x56 0x45 0x52 0x53 0x49 0x4f 0x4e 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00",
);

my %options=();

getopts("a:b:i", \%options);
if ( $options{i} ) {
	interactive();
} else {
	unless ( defined $options{b} ) {
		print "ERROR: no BMC host specified with -b flag\n";
		help();
		exit 1;
	} else {
		$IP = $options{b};
		$PW = ( $options{a} ? $options{a} : "ADMIN" );
	}
}

$IPMI = "ipmitool -I lanplus -U $USER -P $PW -H $IP ";

foreach $data (keys %rawSize) {
	$cmd = $IPMI . $rawSize{$data};
	print "Command: $data $cmd\n";
	$size = `$cmd`;
	chop $size;
	print $size
	$size2 = "0x" . join '', reverse split /(\w\w)/, $size;
	$size2 =~ s/ //g;
	$blocks = int(hex($size2) / $CHUNK );
	print "Partition Size: $size ( $size2 ) ", hex($size2) . " Blocks: $blocks of $CHUNK bytes\n";
	for ( my $count = 0; $count < $blocks; $count++) {
		$offset = sprintf "%08x", $count * 254;
		$offset =~ m/(..)(..)(..)(..)/;
		$offset2 = "0x" . $4 . " 0x" . $3 . " 0x" . $2 . " 0x" . $1;
		#printf "XXXX %s %s XX %s YY %s\n", $count, $blocks, $offset, $offset2;
		$cmd = $IPMI . $rawData{$data} . " " . $offset2;
		print "Getting $data Block $count $cmd\n";
		system "$cmd";
	}	
}

sub roundup {
	my $n = shift;
	print "xxx $n\n";
    	return(($n == int($n)) ? $n : int($n + 1));
}

sub interactive {
	print "Interactive Mode\n";
	print "BMC address (IP or hostname)               : ";
	$IP = <STDIN>; chop $IP;
	print "BMC admin password (default ADMIN)         : ";
	$PW = <STDIN>; chop $PW; unless ($PW) { $PW = "ADMIN"; }
	print "BMC $IP PW $PW\n";
}


sub help {
	print "usage: $0 { -b bmc_address | -i } [-a admin_pw]\n";
	print "Flags:\n";
	print "   -b BMC hostname or IP address\n";
	print "   -a BMC ADMIN password if changed from default (ADMIN)\n";
	print "   -i Interactive mode\n";
}

