#!/usr/bin/perl

#
# Get trace log files
#

use strict;
use Cwd;
#use POSIX;
use Getopt::Long;
use File::Basename;

# options and usage
my $target = '';                        # Target BMC name / IP  (convert to IP)
my $userid = 'ADMIN';                   # BMC user id to use for the ipmitool cmd
my $passwd = 'ADMIN';                   # BMC password to use for the ipmitool cmd
my $output_path = cwd();
my $log_file = "bmc_log.tar.gz";
my $debug = 0;
my $usage = 0;
my $version = "20170317";

my $progname = basename($0);

# for ipmitool cmd
my $rsvId_lsb = 0;
my $rsvId_msb = 0;
my $fileSize = 0;

sub printUsage
{
    print "Usage:  $progname [-h] -t <BMC Name / IP> [-U <userid>] [-P <password>]\n";
    print "                  [-o <output dir>] # default: $output_path\n";
    print "                  [-l <log file>] # default: $log_file\n";
    print "version: $version\n";
    print "\n";
    print "This tool will ONLY get BMC tracelog data.\n";
    exit;
}

GetOptions(
    "t:s" => \$target,
    "U:s" => \$userid,
    "P:s" => \$passwd,
    "o:s" => \$output_path,
    "l:s" => \$log_file,
    "v+" => \$debug,
    "h" => \$usage,
    ) || printUsage();

if ($usage)
{
    printUsage();
}

#################################
# Variables used for the script #
#################################

###############################################################
# Add code to check that we have the needed fields filled in  #
###############################################################
($target)     || die "Missing BMC target name / IP\n";
($userid)     || die "Missing BMC user id\n";
($passwd)     || die "Missing BMC password\n";

if ($debug > 0)
{
    logger( "target: \"$target\"\n");
# 20180510 DJM GDPR NO! NO!s
#    logger( "userid: \"$userid\"\n");
#    logger( "passwd: \"$passwd\"\n");
    logger( "output_path: \"$output_path\"\n");
    logger( "debug: $debug\n");
    logger( "version: $version\n");
}

#########################################################################################
#                                     Main body                                         #
#########################################################################################

die if (ipmiPrepRsvId());
die if (ipmiPrepDownload());
die if (ipmiDownloadFile());
ipmiDownloadDone();


#########################################################################################
#                                   Functions                                           #
#########################################################################################

#
# output: rsvId_lsb and rsvId_msb is set with reservation Id for download file
# return: 0 if successful; -1 if error
#
sub ipmiPrepRsvId {
    my $cmd = "ipmitool -I lanplus -H $target -U $userid -P $passwd raw 0x30 0xa0 0x05 0x0d 2>&1";
    $debug && logger( "ipmi cmd = $cmd\n");
    my @ipmiRet = qx/$cmd/;
    if (@ipmiRet[0] =~ /^\s*([[:xdigit:]]+)\s+([[:xdigit:]]+)/) {
        $rsvId_lsb = $1;
        $rsvId_msb = $2;
        $debug && logger( "ipmiPrepRsvId rsvId = $rsvId_msb$rsvId_lsb\n");
        return 0;
    } else {
        logger( "ipmiPrepRsvId returns error\n");
        return -1;
    }
}

#
# returns: 0 when file is ready to download; -1 if error
# output: fileSize is set
#
sub ipmiPrepDownload
{
    my $cmd = "ipmitool -I lanplus -H $target -U $userid -P $passwd raw 0x30 0xa0 0x06 0x$rsvId_lsb 0x$rsvId_msb 2>&1";
    my $notDone = 1;
    my $size3 = 0;
    my $size2 = 0;
    my $size1 = 0;
    my $size0 = 0;
    $debug && logger( "ipmi cmd = $cmd\n");
    while ( $notDone ) {
        my @ipmiRet = qx/$cmd/;
        $debug && logger( "ipmiRet " . $ipmiRet[0]);
        # cmd return retStatus size0 size1 size2 size3
        if (@ipmiRet[0] =~ /^\s*([[:xdigit:]]+)\s+([[:xdigit:]]+)\s+([[:xdigit:]]+)\s+([[:xdigit:]]+)\s+([[:xdigit:]]+)/) {
            $notDone = hex($1);
            $size0 = hex($2);
            $size1 = hex($3);
            $size2 = hex($4);
            $size3 = hex($5);
            $fileSize = ($size3 << 24) | ($size2 << 16) | ($size1 << 8) | $size0;
        } else {
            logger( "ipmiPrepDownload return error\n");
            return -1;
        }
    }
    $debug && logger(sprintf("ipmiPrepDownload fileSize = %d (0x%x)\n", $fileSize, $fileSize));
    return 0;
}

#
# returns: 0 if successful; -1 if error
#
sub ipmiDownloadFile
{
    my $cmdBase = "ipmitool -I lanplus -H $target -U $userid -P $passwd raw 0x30 0xa0 0x07 0x$rsvId_lsb 0x$rsvId_msb";
    my $cmd = "";
    my $totalSize = 0;
    my $transferSize = 512;
    my $size = 0;
    my $output_file = "$output_path/$log_file";
    my $file;
    open($file, ">:raw", "$output_file") or die "Failed to open $output_file";
    while ( $totalSize < $fileSize ) {
        $size = $fileSize - $totalSize;
        if ( $size > $transferSize ) {
            $size = $transferSize;
        }
        # add offset and size to ipmitool cmd
        $cmd = sprintf("$cmdBase 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 2>&1",
                        ($totalSize & 0xff), (($totalSize >> 8) & 0xff),
                        (($totalSize >> 16) & 0xff) , (($totalSize >> 24) & 0xff),
                        ($size & 0xff), (($size >> 8) & 0xff));
        $debug && logger( "ipmi cmd = $cmd\n");
        my @ipmiRet = qx/$cmd/;
        $debug && logger( "ipmi cmd = ($cmd)\n");
        $debug && logger( "ipmiRet " . $ipmiRet[0] . "\n");
        $debug && logger( "===============\n");
        foreach (@ipmiRet) {
            $debug && logger( "$_");
        }
        $debug && logger( "===============\n");
        $size = 0;
        if (@ipmiRet[0] =~ /^\s*([[:xdigit:]]+)\s+/) {
            foreach (@ipmiRet) {
                my $line = $_;
                $line =~ s/^\s+|\s+$//g;
                my @hexBytes = split(' ', $line);
                my @bytes = ();
                foreach (@hexBytes) {
                    push(@bytes, pack('H2', $_));
                    $size = $size + 1;
                }
                print $file @bytes;
            }

        } else {
            logger( "ipmiDownloadFile returns error\n");
            close($file);
            return -1;
        }

        $totalSize = $totalSize + $size;
    }
    close($file);
    return 0;
}

#
#
sub ipmiDownloadDone {
    my $cmd = "ipmitool -I lanplus -H $target -U $userid -P $passwd raw 0x30 0xa0 0x08 0x$rsvId_lsb 0x$rsvId_msb 2>&1";
    $debug && logger( "ipmi cmd = $cmd\n");
    my @ipmiRet = qx/$cmd/;
}

# 20180510 DJM
# plc.pl needs a UID/PWD puller for the logging functions above
#
sub cln_gdpr {
  (my $val) = @_;
  $val =~ s/-U\s{1,}\S{1,}\s/-U ****** /g;
  $val =~ s/-P\s{1,}\S{1,}\s/-P ****** /g;
  return $val;
}

# 20180510 DJM
# Use logger for verbose printing as well as output display messages so that
# GDPR PI data can be removed (user/password fields)
#
sub logger {
    (my $msg) = @_;
#    open (my $fh, '>>', $OUTDIR . $STATUS_OUTFILE);
    $msg = cln_gdpr($msg);
#    print $fh $msg;
    print $msg;
#    close $fh;
}

