#! /bin/sh
#
# kcat_producer.sh - Send data to a KAFKA topic
#
# Use Netcool/OMNIbus Java if available
#
if [ -z "$NCHOME" ]
then
# Set your preferred Java here
JAVA_HOME=/
else
JAVA_HOME=$NCHOME/platform/linux2x86/jre64_1.8.0/jre
fi

# Check for Java
if [ ! -d $JAVA_HOME ]
then
echo "Please set JAVA_HOME in the script correctly"
exit
fi

if [ ! -f $JAVA_HOME/bin/java ]
then
echo "Cannot find Java in JAVA_HOME/bin"
exit
fi

export DATE
DATE=`date`
export CLASSPATH JAVA_HOME JAVA
CLASSPATH=`ls -1 libs/*.jar| awk '{printf "%s:",$1}'`
# echo $CLASSPATH

if [ $# -ne 3 ]
then
echo "Usage: `basename $0` [host]:[port] [topic] [normal|debug]"
echo
echo "Provide the Kafka host:port to connect for sending to topic"
exit
fi
HOST_PORT=$1
TOPIC=$2
OPTION=$3
export HOST_PORT TOPIC OPTION


JAVA=$JAVA_HOME/bin/java

if [ "$OPTION" = "normal" ]
then
# Normal options
$JAVA -cp $CLASSPATH kafka.tools.ConsoleProducer --producer.config client.properties --broker-list ${HOST_PORT} --topic ${TOPIC} << EOF
{"eventfactory":[{"heartbeat-id":"1234567890","timestamp":"$DATE","summary":"Heartbeat","severity":"information"}]}

EOF
else
# Debug options
$JAVA -Dlog4j.configuration=file:./connect-log4j.properties -cp $CLASSPATH kafka.tools.ConsoleProducer --producer.config client.properties --broker-list ${HOST_PORT} --topic ${TOPIC} << EOF
{"eventfactory":[{"heartbeat-id":"1234567890","timestamp":"$DATE","summary":"Heartbeat","severity":"information"}]}

EOF

fi

# EOF
