#! /bin/sh
#
# kcat_consumer.sh - Consume KAFKA data from a topic
#
# Use Netcool/OMNIbus Java if available
#
if [ -z "$NCHOME" ]
then
# Set your preferred Java here
JAVA_HOME=/
else
JAVA_HOME=$NCHOME/platform/linux2x86/jre64_1.8.0/jre
fi

# Check for Java
if [ ! -d $JAVA_HOME ]
then
echo "Please set JAVA_HOME in the script correctly"
exit
fi

if [ ! -f $JAVA_HOME/bin/java ]
then
echo "Cannot find Java in JAVA_HOME/bin"
exit
fi

export CLASSPATH JAVA_HOME JAVA
CLASSPATH=`ls -1 libs/*.jar| awk '{printf "%s:",$1}'`
# echo $CLASSPATH

if [ $# -ne 3 ]
then
echo "Usage: `basename $0` [host]:[port] [topic] [normal|debug]"
echo
echo "Provide the Kafka host:port to connect for sending to topic"
exit
fi
HOST_PORT=$1
TOPIC=$2
OPTION=$3
export HOST_PORT TOPIC OPTION

JAVA=$JAVA_HOME/bin/java

if [ "$OPTION" = "normal" ]
then
# Normal command usage
$JAVA -cp $CLASSPATH kafka.tools.ConsoleConsumer --consumer.config client.properties --from-beginning  --topic ${TOPIC} --bootstrap-server ${HOST_PORT}

else

# With debugging options
$JAVA -cp $CLASSPATH -Dlog4j.configuration=file:./connect-log4j.properties kafka.tools.ConsoleConsumer --consumer.config client.properties --from-beginning  --topic ${TOPIC} --bootstrap-server ${HOST_PORT}

fi
# EOF
