import json
import os
import sys
import calendar
import time
from datetime import timezone 
import datetime 
import uuid 


#print(sys.argv)
if len(sys.argv)==1 or len(sys.argv)>2:
	print("parser.py accepts exactly one argument. Please pass the file name. Ex python parser.py /etc/example.json")
	sys.exit(1)
input_file=sys.argv[1]
if not os.path.isfile(input_file):
	print("Input file not found!!")
	sys.exit(1)
if not os.path.isdir('output'):
	os.mkdir('output')
with open("config/incident_sample.json", "r") as read_file:
	#print("Reading Mapping Rules into Python dictionary")
	incident_sample = json.load(read_file)
	incident_sample_data=incident_sample["data"]
				
#Read Mapping Rules and store it into a dictionary
with open("config/map_rules.json", "r") as read_file:
	#print("Reading Mapping Rules into Python dictionary")
	map_rules = json.load(read_file)
	map_incident=map_rules["data"]
	#print(map_incident)
	

	
with open(input_file, "r") as read_file:
	#print("Reading Mapping Rules into Python dictionary")
	incident_data = json.load(read_file)
	member=incident_data['member']
	#for item in member:
	#		print(item["_id"])

#Storing sample data to temp vars

incident_list=[]
for incident_details in member:
##For a single member m[0]
#for Incident main object
			#Load sample data
			if(incident_details["status"]=='CLOSED'):
				with open("config/incident_sample.json", "r") as read_file:
					#print("Reading Mapping Rules into Python dictionary")
					#incident_sample = json.load(read_file)
					data = read_file.read()
					incident_sample = eval(data)
					incident_sample_data=incident_sample["data"]
					#print(incident_sample)
				temp_incident_details = incident_details
				for key, value in map_incident.items():
					value_type = type(value)
					#print(value_type)
					#const delimiter = '-'
					json_value = ""
					if value_type == dict:
						combined_val = ""
						arr = []
						for k in value:
							#print(value[k])
							#str_value = (str)(value[key])
							arr_value = (str)(incident_details.get(value[k]))
							if arr_value != 'None':
								arr.append(arr_value)	
							
						json_value = " - ".join(arr)
						#print(json_value)
					else :
						temp = value
						arr = temp.split(".")
						
						length = len(arr)
						for i in arr:
							if length == 1:
								#print(type(json_value))
								try:
									json_value = incident_details.get(i)
									#print(json_value)
									#if json_value == null:
									#	json_value = ""
								except:
									#print('')
									json_value = ""
							else :

								try:
									
									tempjson = incident_details.get(i)  
									json_type = type(tempjson)
									#print(json_type)
									if json_type == list:
										#print('json type is list here')
										if i == 'relatedrecord':
											for t in tempjson:
												if t['relatedrecclass'] == "PROBLEM":
													incident_details = t
										else:
											incident_details = tempjson[0]
									else:
										incident_details = tempjson
								except:
									#print('')
									incident_details[i]=""
									#json_value = ""
									#incident_related_incident_data.append({"source_incident_id":"","relationship":""})
							
							length = length -1

						#print(json_value)

					json_val_type = type(json_value)
					if json_val_type == str:
						json_val_len = len(json_value)
						if json_val_len == 0 :
							json_value = ""
						incident_sample_data[key] = json_value
					
					incident_details = temp_incident_details
        			
					incident_sample["type"]=incident_sample_data["type"]
					incident_sample["source"]=incident_sample_data["instance"]
				
				incident_sample["id"] = str(uuid.uuid4().hex.upper()[0:15]) + "-" +str(uuid.uuid4().hex.upper()[0:16])

				#dt = datetime.datetime.now() 
				#utc_time = dt.replace(tzinfo = timezone.utc) 
				incident_sample["time"]=str(datetime.datetime.now().isoformat())
				incident_list.append(incident_sample)
				#print(incident_sample)
				print(json.dumps(incident_sample, indent=True))
with open('output/output.json', 'w') as outfile:
			outfile.write("[")
			for i in incident_list:
					 json.dump(i, outfile)
					 outfile.write(",")
					 outfile.write("\n")
			outfile.write("]")
print("Script completed successfully Please check output folder for generated json.")