package custom.idz;
/*
 * All source code and/or binaries attached to this document are referred to here as "the Program". 
 * IBM is not providing program services of any kind for the Program. 
 * IBM is providing the Program on an "AS IS" basis without warranty of any kind. 
 * IBM WILL NOT BE LIABLE FOR ANY ACTUAL, DIRECT, SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES 
 * OR FOR ANY ECONOMIC CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN IF IBM, 
 * OR ITS RESELLER, HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * */



import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;

/*
 * export it to a jar file, like c:\mydata\cases\mypreproc.jar
 * 
 * Configure it on a property group, tab COBOL or PLI
 * item Local preprocessor, click New
 * 
 * (assuming you edit directly from remote systems explorer)
 * 
 * preprocessor name=C:\IBM\IDz142\jdk\jre\bin\javaw.exe
 * preprocessor arguments=-cp c:\mydata\cases\plinot.jar custom.idz.PliNot ${resource_loc} ${rdz_cache_home}\BuildOutput\${resource_fn}.tmp
 * preprocessor outfile name=${resource_fn}.tmp
 * 
 */
public class PliNot {

	PrintStream log = null;
	boolean debug=false;
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		PliNot task = new PliNot();
		task.execute(args);
	
	}

	private void execute(String[] args) {
		File in;
		File out;
		OutputStreamWriter writer = null;
		BufferedReader reader = null;

		try {
			if (args.length<2){
				System.err.println("command line error, too few arguments. Usage is arg1=input file, arg2=output file, arg3=log file (optional)");
				System.exit(-1);
			} 
			if (args.length==3){
				//"c:\\mydata\\cases\\mypreproc.log"
				log = new PrintStream(args[2]);
				debug=true;
			}
			
			log("JAVA PREPROCESSOR start");
							
			log("reading from " + args[0]);
			log("writing to " + args[1]);
			in = new File(args[0]);
			out = new File(args[1]);

			if (in.exists()) {
				writer = null;
				reader = new BufferedReader(
						new InputStreamReader(new FileInputStream(in), Charset.forName("UTF-8").newDecoder()));

				writer = new OutputStreamWriter(new FileOutputStream(out), Charset.forName("UTF-8").newEncoder());

				String strLine;

				// read the file line by line
				while ((strLine = reader.readLine()) != null) {
					log("read line=" + strLine);
					strLine = fixPli(strLine);
					log("write line=" + strLine);
					writer.write(strLine);
					writer.write("\n");

				}
				writer.flush();
				log("JAVA PREPROCESSOR end");
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// } catch (InterruptedException e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
		} finally {
			try {
				if (writer != null)
					writer.close();
				if (reader != null)
					reader.close();
				if (log != null)
					log.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}

	private static String fixPli(String strLine) {
		PliLine srcLine = new PliLine(strLine);
		return srcLine.fixPliNot();
	}


	private void log(String msg){
		if(debug)
			log.println(msg);
	}
}
