#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_ls and display
#  in a terse format the information. By 'greping' on the output for "=",
#  only the active links stations will be displayed.
#  Then issue query_dlur_pu and query_lu_0_to_3 to get DLUS 'links status'
#

use strict;

 my ( $line, $lsname, $inusestr, $num_links, $num_active_links, $srv_index, $srvcnt,
      $actsesscnt, $num_inactive_links, $state, $num_pus, 
      $appl_status, $plu_status, $num_inactive_pus, $num_active_pus, @servername, 
      @data, @dlusstatus, @pustate, @puname, @status );

#  Initialize for scalar declaration
$lsname = " ";
$srvcnt = 0;


@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";

print "   Link      Active  Number   Active   Inactive    Active    Server \n";
print "  stations  stations   PUs      PUs       PUs     sessions    name  \n";
print " --------- --------- ------- -------- ---------- ---------- --------\n";
   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{
   $num_links = 0;
   $num_active_links = 0;
   $num_inactive_links = 0;
   $actsesscnt = 0;
   $num_inactive_pus = 0;
   $num_active_pus = 0;
   $num_pus = 0;

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_ls` or die "Node $servername[$srv_index] not recognized $!\n";

   $line =0;
   foreach(@status) {
      chomp;
      if (/^query_ls/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }
 
  #  Skip headers
      next if (/^------/);
      next if (/^list_option/);

      next if (/^\n/);

      @data = split(/=/,$_);   #Break parameter = value

      next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

      if ($data[0]=~m/^ls_name/) {       # get link station name  
        $num_links++;
        next;
      } elsif ($data[0]=~m/^act_sess_count/) { # Determined HPR type 
        $actsesscnt += $data[1];
        next;                     
      } elsif ($data[0]=~m/^state/) { # Determined HPR type 
        $state = $data[1];
        $state=~s/ //g;
        next;             
      }  else {                          # output line if end of record 
        if ($data[0]=~m/^max_retry/)  {   # ... the max retry variable is end of record
                # Print information #
           if ($state=~m/_ACTIVE/) {  
              $num_inactive_links++;
           } elsif ($state=~m/ACTIVE/) {
              $num_active_links++;
           }
        }
        $line++;       
      }
   
   }
# print "\n------------------------------------------------\n";

   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
   $num_pus = 0;

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_dlur_pu` or die "Node $servername[$srv_index] not recognized $!\n";

   $line =0;
   foreach(@status) {
      chomp;
      if (/^query_dlur_pu/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

  #  Skip headers
      next if (/^------/);
      next if (/^list_option/);
      next if (/^filter/);
      next if (/^\n/);

      @data = split(/=/,$_);   #Break parameter = value

      next if (@data == 0);        # on blank line, skip

#  Save status of PU/DLUS for later when counting sessions

      if ($data[0]=~m/^pu_name/) {       # get DLUR PU name  
        $puname[$num_pus] = $data[1];    #  save PU name
        $puname[$num_pus]=~s/ //g;       # remove any spaces as end
        next;   
       } elsif ($data[0]=~m/^pu_status/) { # PU state ... needs to be ACTIVE
        $pustate[$num_pus] = $data[1];    #  save PU State
        $pustate[$num_pus]=~s/ //g;       # remove any spaces as end 
        if ($pustate[$num_pus]=~m/^ACTIVE/) {      # If active, set active, else use defined
           $num_active_pus++;        
        } else {  
           $num_inactive_pus++;
        }            
        next;  
      } elsif ($data[0]=~m/^dlus_session_status/) { # Needs to be ACTIVE
         if ($data[1]=~m/_ACTIVE/) {  
            $dlusstatus[$num_pus] = "Inactive";
         } elsif ($data[1]=~m/ACTIVE/) {
            if ($pustate[$num_pus]=~m/ACTIVE/) {
              $dlusstatus[$num_pus] = "Active"
            } else {
              $dlusstatus[$num_pus] = "Inactive";
            }
         }     
#  printf ("  DLUS Status: %8s \n", $dlusstatus[$num_pus]);
        $num_pus++;                        # Increment count of PUs            
      }    
   }

   $line = 0;

   while ($line < $num_pus) 
   {
     if ($pustate[$line]=~m/^ACTIVE/ ) {
        if ($dlusstatus[$line]=~m/^Active/) {
      
          @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -a query_lu_0_to_3,pu_name=$puname[$line]`or die "Node $servername[$srv_index] not recognized $!\n";
          foreach(@status) {
             chomp;

  #  Skip headers
             next if (/^------/);
             next if (/^list_option/);
             next if (/^\n/);

             @data = split(/=/,$_);   #Break parameter = value

             next if (@data == 0);        # on blank line, skip

             if ($data[0]=~m/^appl_conn_active/) {    # get DLUR PU name  
               $appl_status = $data[1];    #  save application status
               $appl_status=~s/ //g;       # remove any spaces as end
               next;                         
             } elsif ($data[0]=~m/^plu_sess_active/) { # Determined Active DLUS
               $plu_status = $data[1];    #  save PLU application status
               $plu_status=~s/ //g;       # remove any spaces as end
               if ($appl_status =~m/^YES/) {
                  if ($plu_status =~m/^YES/) {  
                        $actsesscnt++;      
                  }
               }
               next;             
             } else  { 
               next;                
             }
          }
        } 
      }
      $line++;                        
   }           

#   Print header line
#   print "   Link      Active  Number   Active   Inactive    Active    Server \n";
#   print "  stations  stations   PUs      PUs       PUs     sessions    name  \n";
#   print " --------- --------- ------- -------- ---------- ---------- --------\n";
 
   printf("    %2d        %2d     %4d       %4d      %4d       %5d   %s \n",
      $num_links, $num_active_links, $num_pus, $num_active_pus, $num_inactive_pus, 
        $actsesscnt, $servername[$srv_index]);
                     
   $srv_index++;  
}
print "\n------------------------------------------------\n";
