#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2017 All rights reserved. #
#                                                           #
#############################################################

#  Purpose of the script is to call snaadmin statys_dependent_lu and display
#  in a terse format the information. By 'grep"ing on the output for "=",
#  only the active API and tn3270 sessions will be displayed.


use strict;
use warnings;

 my ( $line, $puname, $label, $value, @data, @status );

#  Initialize for scalar declaration
$puname = " ";

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin status_dependent_lu`; # Get Dep. LU information
} else {
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $ARGV[0] status_dependent_lu` or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header line
print "\n=  PU:    NAU:    LU:    Status:     Activity: \n";
print "=  ===    ====    ===    =======     ========= ";


$line =0;
foreach(@status) {
   chomp;
   if (/^query_node_limit/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^----/);
   next if (/^PU/);
   next if (/^\n/);   

  #  Print PUs for DLUR/DLUS
   if (/^[A-Z\@\#\$][0-9A-Z\@\#\$]+/) { # Check for SNA PU name chars 
       $puname = substr($_, 0, 8);
       next;
   }

   @data = split(/[\s]+/,$_);   #Break NAU, LU, Type, Status

   next if (@data == 0);        # on blank line, skip

   if ($data[1]=~m/TN3270/) {       # get IP address of client 
     ($label, $value) = split(":",$data[2]);
     printf( "=> %s, ",$value);

   } elsif ($data[1]=~m/Telnet/) {  # either port or type of client
     ($label, $value) = split(":",$data[2]);
     printf("%s, ", $value);

   } elsif ($data[1]=~m/^Security/) { #level of session security
     ($label, $value) = split(":",$data[1]);
     $value=~s/ //g;              # blank out extra blanks
     printf("Sec. = %s ", $value);

   } elsif ($data[1]=~m/^LUA/) { # LUA session running
     print "$data[2] = $data[1] ";

   } elsif ($data[1]=~m/^[^0-9]+/) { # any data not starting with a digit
     print "$data[1] ";
   } elsif ($data[1]=~m/[^0-9]+/) { # any data not starting with a digit
     print "$data[1] ";

   }  else {                     # output NAU, LU status line
     printf("\n %s %3d %8s  %6s ", 
                $puname, $data[1], $data[2], $data[4]);
     $line++;       
   }
}
print "\n------------------------------------------------\n";

