#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($time,  $line, @tracesettings, $node_trace, $appc_trace,
    $fm_trace, $lua_trace, $nof_trace, $ms_trace, $dlpi_trace,
    $lli_trace, $ndlc_trace, $dgrm_trace, $nli_trace,
    $mac_trace, $gdlc_trace, $llc2_trace, $pv_trace, $slim_trace,
    $gsna_trace, $hprip_trace, $check_count, $label, $trace_none,
    $remote_addr, $remote_port, $trunc_length, @retval);

print header;

# output top of template page
print_top();

$trunc_length = 0;
$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
#! Get CSLINKS output
@tracesettings=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_trace_type`;

print "<font face=\"Times New Roman, Helvetica\">";
print "<br><b> Select Trace Options: $time</b>";
print "<br><br>  Current Trace status:<br>\n";
print "<form action= \"/cscbin/actcstrace.cgi\" method=\"post\">\n";

#
# display current trace information
#
$check_count = 0;
foreach $line (@tracesettings) {
   next if $line=~m/^-------/;       # skip border
   if ($line=~m/^trace_flags/) {     # start reading traces
        print $line."<br>\n";
        if ($line=~m/ NONE/) {  #  If trace is off, mark it and go to next line
            $trace_none = 1;
            next;
        }
  #  Test for each flag on line
        if ($line=~m/ NODE/) {
           $node_trace = 1;
           $check_count++;
        } # Node trace
        if ($line=~m/ APPC/) {
           $appc_trace = 1;
           $check_count++;
        } # APPC trace
        if ($line=~m/ FM/) {
           $fm_trace = 1;
           $check_count++;
        } # FM trace
        if ($line=~m/ LUA/) {
           $lua_trace = 1;
           $check_count++;
        } # LUA trace
        if ($line=~m/ NOF/) {
           $nof_trace = 1;
           $check_count++;
        } # NOF trace
        if ($line=~m/ MS/) {
           $ms_trace = 1;
           $check_count++;
        } # Mgmt Serv trace
        if ($line=~m/ DLPI/) {
           $dlpi_trace = 1;
           $check_count++;
        } # DLPI trace
        if ($line=~m/ LLI/) {
           $lli_trace = 1;
           $check_count++;
        } # LLI trace
        if ($line=~m/ NDLC/) {
           $ndlc_trace = 1;
           $check_count++;
        } # NDLC trace
        if ($line=~m/ DGRM/) {
            $dgrm_trace = 1;
           $check_count++;
        } # Datagram trace
        if ($line=~m/ NLI/) {
            $nli_trace = 1;
           $check_count++;
        } # NLI trace
        if ($line=~m/ MAC/) {
            $mac_trace = 1;
           $check_count++;
        } # MAC trace
        if ($line=~m/ GDLC/) {
            $gdlc_trace = 1;
           $check_count++;
        } # GDLC trace
        if ($line=~m/ LLC2/) {
            $llc2_trace = 1;
           $check_count++;
        } # LLC2 trace
        if ($line=~m/ PV/) {
            $pv_trace = 1;
           $check_count++;
        } # PV trace
        if ($line=~m/ SLIM/) {
            $slim_trace = 1;
           $check_count++;
        } # client/server trace
        if ($line=~m/ GSNA/) {
            $gsna_trace = 1;
           $check_count++;
        } # gsna trace
        if ($line=~m/ HPRIP/) {
            $hprip_trace = 1;
           $check_count++;
        } # EE trace
        next;
   }
   if ($line=~m/^truncation_length/) {     # start reading traces
        print $line."<br><br>\n";
        ($label,$trunc_length) = split(/=/,$line);  # Get truncation length
        next;
   }
}
#  Print seperator line
print " <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
print "<td colspan=\"2\" width=\"100%\">\n";
print "<hr size=\"1\" align=\"left\" width=\"100%\" color=\"#000000\" noshade=\"noshade\">\n";
print "</td></table> <table>\n";
#
#   Process lines read for action to set up
#

if ($trace_none) {  # Set NONE flag and skip rest
   print "<table><tr><td> Select <b>ALL</b> to turn on all trace flags: ";
   print "<b>ALL </b><input type=\"checkbox\" name=\"traceopt\" value=\"all\"/>";
} elsif ($check_count == 19) {  # ALL flag is set
   print "<table><tr><td> Select <b>NONE</b> to turn off trace flags: ";
   print "<b>NONE</b><input type=\"checkbox\" name=\"traceopt\" value=\"none\"/>";
} else {
   print "<table><tr><td> Select <b>NONE</b> to turn off traces, <b>ALL</b> to enable all traces:<br>";
   print "<b> NONE </b><input type=\"radio\" name=\"traceopt\" value=\"none\"/>";
   print "<b> ALL </b><input type=\"radio\" name=\"traceopt\" value=\"all\"/>";
}
print "<br><br><b> -OR- </b> \"check\" specific trace flags to enable:&nbsp;&nbsp;&nbsp;&nbsp;<br>";
print "</td></tr>";

# Print check boxes
print "<table><tr><td><br>     ";
#  set Node checkbox
print "<b>NODE</b><input type=\"checkbox\" name=\"node\" value=\"yes\"";
if ($node_trace) { print " checked />"; }
else {print " />"; }
#  set APPC checkbox
print "<b>  APPC</b><input type=\"checkbox\" name=\"appc\" value=\"yes\"";
if ($appc_trace) { print " checked />"; }
else {print " />"; }
#  set FM checkbox
print "<b>  FM</b><input type=\"checkbox\" name=\"fm\" value=\"yes\"";
if ($fm_trace) { print " checked />"; }
else {print " />"; }
#  set LUA checkbox
print "<b>  LUA</b><input type=\"checkbox\" name=\"lua\" value=\"yes\"";
if ($lua_trace) { print " checked />"; }
else {print " />"; }
#  set NOF checkbox
print "<b>  NOF</b><input type=\"checkbox\" name=\"nof\" value=\"yes\"";
if ($nof_trace) { print " checked />"; }
else {print " />"; }
#  set MS checkbox
print "<b> MS</b><input type=\"checkbox\" name=\"ms\" value=\"yes\"";
if ($ms_trace) { print " checked />"; }
else {print " />"; }
#  set DLPI checkbox
print "<b>  DLPI</b><input type=\"checkbox\" name=\"dlpi\" value=\"yes\"";
if ($dlpi_trace) { print " checked /><br>"; }
else {print " /><br>"; }
#
print "</td><tr>\n";
print "<tr><td><br>     ";
#
#  set LLI checkbox
print "<b>  LLI</b><input type=\"checkbox\" name=\"lli\" value=\"yes\"";
if ($lli_trace) { print " checked />"; }
else {print " />"; }
#  set NDLC checkbox
print "<b>  NDLC</b><input type=\"checkbox\" name=\"ndlc\" value=\"yes\"";
if ($ndlc_trace) { print " checked />"; }
else {print " />"; }
#  set DGRM checkbox
print "<b>  DGRM</b><input type=\"checkbox\" name=\"dgrm\" value=\"yes\"";
if ($dgrm_trace) { print " checked />"; }
else {print " />"; }
#  set NLI checkbox
print "<b>  NLI</b><input type=\"checkbox\" name=\"nli\" value=\"yes\"";
if ($nli_trace) { print " checked />"; }
else {print " />"; }
#  set MAC checkbox
print "<b>  MAC</b><input type=\"checkbox\" name=\"mac\" value=\"yes\"";
if ($mac_trace) { print " checked /><br>"; }
else {print " /><br>"; }
#
print "</td><tr>\n";
print "<tr><td><br>     ";
#
#  set GDLC checkbox
print "<b>  GDLC</b><input type=\"checkbox\" name=\"gdlc\" value=\"yes\"";
if ($gdlc_trace) { print " checked />"; }
else {print " />"; }
#  set LLC2 checkbox
print "<b>  LLC2</b><input type=\"checkbox\" name=\"llc2\" value=\"yes\"";
if ($llc2_trace) { print " checked />"; }
else {print " />"; }
#  set PV checkbox
print "<b>  PV</b><input type=\"checkbox\" name=\"pv\" value=\"yes\"";
if ($pv_trace) { print " checked />"; }
else {print " />"; }
#  set SLIM checkbox
print "<b>  SLIM</b><input type=\"checkbox\" name=\"slim\" value=\"yes\"";
if ($slim_trace) { print " checked />"; }
else {print " />"; }
#  set GSNA checkbox
print "<b>  GSNA</b><input type=\"checkbox\" name=\"gsna\" value=\"yes\"";
if ($gsna_trace) { print " checked />"; }
else {print " />"; }
#  set HPRIP checkbox
print "<b>  HPRIP</b><input type=\"checkbox\" name=\"hprip\" value=\"yes\"";
if ($hprip_trace) { print " checked /></td></tr>\n"; }
else {print " /></td></tr>\n"; }
#
#
print "<tr><td><br>";
print "Enter truncation length: <input type=\"text\" name=\"trunc_length\" value=\"$trunc_length\"/>\n";

print "</td></tr></tbody></table></table>";
print "<br>";

@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";
print "   <input type=\"reset\" name=\"reset\" value=\"Reset\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
