#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $time, $line, @contents, @listing);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Web Admin Get Problem Determination File: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";
#
#   Get output file for snagetpd 
#
if (! param) {
   print "Invalid invocation of snagetpd file!";
} else {
   $arg=param('snagetpdfile');
   if ($arg =~ m/[^a-zA-Z0-9._\/]/) {
       print "</p><p> Invalid Input Received!! </p></form></font>";a
       print "</b></font></p>";
       open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
       @contents=<SOURCE>;
       print @contents;
       close (SOURCE);
       exit 1;
   }

   if ($arg eq "") {  
      $arg = "/tmp/pd";
   } elsif (-d $arg) {  # if input is directory, set directory/pd.tar.gz
      $arg.="/pd";
   }       
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snagetpd -q $arg`;
# Display output of snagetpd
print "<br> Display Output from snagetpd:";
foreach $line (@contents) {
   next if ($line=~m/-----/);   # Do not display seperaters
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
#
#  Display a directory listing to show file size
#
@listing = `ls -l $arg*`;
print "<br>-------------------------";
print "<br> Output file information:<b>";
foreach $line (@listing) {
   $line= substr($line,32,55);  # skip permissions and owner/group
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</b></font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0; 

