#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;
#
#   Define variables needed for token
#

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_alias, $arg_descr, $arg_cpname, $arg_nodetype, $arg_nodeid, 
    $arg_ms_support, $description, $remote_port, $port_name, $hash, $token, 
    $up_time, $remote_addr, $time, $line, @data, @contents, @listing);

$arg_alias="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#   
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
# Display output of snaadmin query_node
foreach $line (@contents) {
   next if ($line=~m/-----/);   # Do not display seperaters
      
   if ($line=~m/failed :/) {
        print "Failed to access the node. \n";
        exit -1;
    }
       
   if ($line=~m/descript/) {
      @data = split(/=/,$line);   #Break CP name, Type, Descr
      $data[1]=~s/^\s+//;         #Get rid of leading blanks
      $data[1]=~s/\s+$//;         #Get rid of trailing blanks
      $arg_descr = substr($data[1],0,31);  #Only get first 31 characters
      if ($arg_descr =~ m/[^a-zA-Z0-9_#@$!i+ ]/) {
         print "</p><p> Invalid Character in description field !! </p></form></font>";
         exit -2;
      } 
      next;

   } elsif ($line=~m/node_type/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
      $arg_nodetype = $data[1];
      next;

   } elsif ($line=~m/fqcp_name/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_cpname = $data[1];
      if ($arg_cpname =~ m/[^A-Z0-9.]/) {
         print "</p><p> Invalid Character in CP Name field (Uppercase only) !! </p></form></font>";
         exit -2;
      }	 
      next;
   } elsif ($line=~m/cp_alias/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_alias = $data[1];
      next;
   } elsif ($line=~m/node_id/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_nodeid = $data[1];
      $arg_nodeid=~s/<//g;
      $arg_nodeid=~s/>//g;
      next;         
   } elsif ($line=~m/ms_support/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_ms_support = $data[1];
      next;
   } elsif ($line=~m/up_time/) {
      @data = split(/=/,$line);   #Break time in hundreths of second
      $data[1]=~s/^\s+//;         #Get rid of leading blanks
      $data[1]=~s/\s+$//;         #Get rid of trailing blanks
      $up_time =$data[1];
      next;
   }else {
     next;
   }

}

#
#  Calculate token and then get hash value 
#
$token = $remote_addr."_".$remote_port."_".$up_time;
$hash = md5_hex($token);

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/definenode.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Define CP Alias
print "<tr> <td>* Control Point alias :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"nodecpalias\"  maxlength=\"8\" value=\"$arg_alias\" required=\"required\" /oninput=\"value=value.replace(/[^a-zA-Z0-9#@\$]/g,'')\" /></td></tr>";
    
    #   Define Description field
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"nodedescript\"  maxlength=\"31\" value=\"$arg_descr\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\"></td></tr>";
    
    #   Define CP Name
print "<tr> <td>* Control Point name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"nodecpname\"  maxlength=\"17\" value=\"$arg_cpname\" required=\"required\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    
    #   Define APPN Node Type
print "<tr> <td>Node Type : </td> <td><select name=\"nodetype\"  class=\"rightAligned\" value=\"$arg_nodetype\" >  ";
if ($arg_nodetype =~/^END_/) {
     print "<option value=\"END_NODE\" selected=\"selected\">END NODE</option> ";
     print "<option value=\"NETWORK_NODE\">NETWORK NODE</option> ";
     print "<option value=\"BRANCH_NETWORK_NODE\">BRANCH EXTENDER</option> </select></td></tr>";
}elsif ($arg_nodetype =~/^NETWORK_/) {
     print "<option value=\"END_NODE\">END NODE</option> ";
     print "<option value=\"NETWORK_NODE\" selected=\"selected\">NETWORK NODE</option> ";
     print "<option value=\"BRANCH_NETWORK_NODE\">BRANCH EXTENDER</option> </select>";
} else {
    print "<option value=\"END_NODE\">END NODE</option> ";
    print "<option value=\"NETWORK_NODE\">NETWORK NODE</option> ";
    print "<option value=\"BRANCH_NETWORK_NODE\" selected=\"selected\">BRANCH EXTENDER</option> </select></td></tr>";
}
#   Define Node ID 
print "<tr> <td>Node ID :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"nodeid\"  maxlength=\"8\"  value=\"$arg_nodeid\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";
#   Define NM-API Style
    #    if ($arg_ms_support =~/^NORMAL/) {
    #    print " NM-API Style :        <select name=\"ms_support\"  class=\"rightAligned\ value=\"$arg_ms_support\" />  ";
    #    print "<option value=\"NORMAL\" selected=\"selected\">NORMAL</option> ";
    #     print "<option value=\"BACK_LEVEL\">BACK_LEVEL</option> ";
    #    print "<option value=\"MIGRATION_LEVEL\">MIGRATION_LEVEL</option> </select>";
    #}elsif ($arg_ms_support =~/^BACK_/) {
    #     print " NM-API Style :        <select name=\"ms_support\"  class=\"rightAligned\ value=\"$arg_ms_support\" />  ";
    #    print "<option value=\"NORMAL\">NORMAL</option> ";
    #    print "<option value=\"BACK_LEVEL\" selected=\"selected\">BACK_LEVEL</option> ";
    #    print "<option value=\"MIGRATION_LEVEL\">MIGRATION_LEVEL</option> </select>";
    #} else {
    #    print " NM-API Style :        <select name=\"ms_support\" class=\"rightAligned\ value=\"$arg_ms_support\" />  ";
    #    print "<option value=\"NORMAL\">NORMAL</option> ";
    #    print "<option value=\"BACK_LEVEL\">BACK_LEVEL</option> ";
    #    print "<option value=\"MIGRATION_LEVEL\" selected=\"selected\">MIGRATION_LEVEL</option> </select>";
    #}

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

