#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_default_record, $arg_client_address, $arg_port_number, 
    $arg_listen_local_address, $arg_description, $arg_lu_name, 
    $arg_printer_lu_name, $arg_tn3270_support, $arg_allow_specific_lu,
    $arg_ssl_enabled, $arg_security_level, $client_address, 
    $listen_local_address, $description, $lu_name, $printer_lu_name,
    $time, $remote_addr, $remote_port, $line, @data, @contents, @dlist, 
    @plist, @retval);

$arg_port_number="";
$arg_default_record="NO";
$arg_client_address="";
$arg_port_number="";
$arg_listen_local_address="";
$arg_description="";
$arg_printer_lu_name="";
$arg_lu_name="";
$arg_tn3270_support="TN3270E";
$arg_allow_specific_lu="YES";
$arg_ssl_enabled="NO";
$arg_security_level="SSL_AUTHENTICATE_MIN";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3 -d`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/^lu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        $lu_name=$data[1];
        next;
    }elsif ($line=~m/lu_model/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        if ($data[1]=~m/3270_DISPLAY/ || $data[1]=~m/UNKNOWN/ ) {
            push @dlist, $lu_name;
        }elsif($data[1] =~/PRINTER/){
            push @plist, $lu_name;
        }
        next;
    }
}

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_pool`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/^pool_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @plist, $data[1];
        push @dlist, $data[1];
        next;
    }
}

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addtnaccess.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Allow access to all TN3270 clients?
print "<tr> <td>Allow access to all TN3270 clients ? </td> <td><select name=\"default_record\"  class=\"rightAligned\" value=\"$arg_default_record\" >  ";
print "<option value=\"NO\" >NO</option> ";
print "<option value=\"YES\" selected=\"selected\">YES</option> </select></td></tr>";

print "<tr> <td> -----------</td> </tr>";    
print "<tr> <td>If NO, </td> </tr>";
    
    #    Client address or name
print "<tr> <td> Client address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"client_address\"  maxlength=\"255\" value=\"$arg_client_address\" oninput=\"value=value.replace(/[^0-9a-zA-Z_-:.]/g,'')\" /></td></tr>";

print "<tr> <td> -----------</td> </tr>";
    
    #   * TCP/IP port number
print "<tr> <td>* TCP/IP port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"port_number_unique\"  maxlength=\"5\" value=\"$arg_port_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\" /></td></tr>";
    
    
    #   Local listen address
print "<tr> <td> Local listen address : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"listen_local_address\"  maxlength=\"45\" value=\"$arg_listen_local_address\" oninput=\"value=value.replace(/[^0-9a-fA-F:.]/g,'')\" ></td></tr>";
   
    #    Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #  Display LU assigned
print "<tr><td>Display LU assigned :</td> <td><select name=\"lu_name\" class=\"rightAligned\" value=\"$arg_lu_name\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@dlist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #   Printer LU assigned
print "<tr> <td>Printer LU assigned :</td> <td><select name=\"printer_lu_name\" class=\"rightAligned\" value=\"$arg_printer_lu_name\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@plist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    # TN3270 Support
print "<tr><td>TN3270 Support :</td> <td><select name=\"tn3270_support\"  class=\"rightAligned\" value=\"$arg_tn3270_support\" >  ";
print "<option value=\"TN3270E\" selected=\"selected\">TN3270E</option> ";
print "<option value=\"TN3270\" >TN3270</option> </select></td></tr>";
    
    #  Allow access to specific LU
print "<tr><td>Allow access to specific LU : </td> <td><select name=\"allow_specific_lu\"  class=\"rightAligned\" value=\"$arg_allow_specific_lu\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   SSL secure session
print "<tr><td>SSL secure session : </td> <td><select name=\"ssl_enabled\"  class=\"rightAligned\" value=\"$arg_ssl_enabled\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"YES_WITH_CLI_AUTH\">YES_WITH_CLI_AUTH</option> </select></td></tr>";
   
print "<tr> <td> If YES or YES_WITH_CLI_AUTH, </td> </tr>";
    
    #   Security level
print "<tr><td>Security level : </td> <td><select name=\"security_level\"  class=\"rightAligned\" value=\"$arg_security_level\" >  ";
print "<option value=\"SSL_AUTHENTICATE_MIN\" selected=\"selected\">SSL_AUTHENTICATE_MIN</option> ";
print "<option value=\"SSL_AUTHENTICATE_ONLY\">SSL_AUTHENTICATE_ONLY</option> ";
print "<option value=\"SSL_40_BIT_MIN\">SSL_40_BIT_MIN</option> ";
print "<option value=\"SSL_56_BIT_MIN\">SSL_56_BIT_MIN</option> ";
print "<option value=\"SSL_128_BIT_MIN\">SSL_128_BIT_MIN</option> ";
print "<option value=\"SSL_168_BIT_MIN\">SSL_168_BIT_MIN</option> ";
print "<option value=\"SSL_256_BIT_MIN\">SSL_256_BIT_MIN</option> </select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

