#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_fqplu_name, $arg_description, $arg_lu_alias, $arg_password, 
    $description, $lu_alias, $time, $remote_addr, $remote_port, $line, 
    @data, @contents, @list, @retval);

$arg_fqplu_name="";
$arg_description="";
$arg_lu_alias="";
$arg_fqplu_name="";
$arg_password="0000000000000000";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/lu_alias/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addss.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #    Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #  Local LU alias
print "<tr><td>Local LU alias :</td> <td><select name=\"lu_alias\" class=\"rightAligned\" value=\"$arg_lu_alias\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@list) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #   * Fully-qualified partner LU name
print "<tr> <td>* Fully-qualified partner LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fqplu_name_ss_unique\"  maxlength=\"17\" value=\"$arg_fqplu_name\" required=\"required\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #   * Password
print "<tr> <td>* Password : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"password\"  maxlength=\"16\" value=\"$arg_password\" required=\"required\" /oninput=\"value=value.replace(/[^A-F0-9]/g,'')\" /></td></tr>";
    
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

