#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_sym_dest_name, $arg_lu_alias, $arg_partner_lu_name, 
    $arg_description, $arg_mode_name, $arg_tp_name_type, $arg_tp_name, 
    $arg_conversation_security_type, $arg_security_user_id, $remote_addr,
    $arg_security_password, $description, $security_password, $remote_port,
    $security_user_id, $tp_name, $lu_alias, $partner_lu_name, $mode_name, 
    $time, $line, @data, @contents, @list, @modelist, @retval);

$arg_sym_dest_name="";
$arg_description="";
$arg_lu_alias="";
$arg_partner_lu_name="";
$arg_mode_name="";
$arg_tp_name_type="APPLICATION_TP";
$arg_tp_name="";
$arg_conversation_security_type="NONE";
$arg_security_password="";
$arg_security_user_id="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/lu_alias/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_mode_definition`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/mode_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @modelist, $data[1];
        next;
    }
}
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_side.cgi\" method=\"post\">\n";
    
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #  * Symbolic destination name
print "<tr><td>* Symbolic destination name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"sym_dest_name_unique\" maxlength=\"8\" value=\"$arg_sym_dest_name\" required=\"required\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #  Local LU Alias
print "<tr><td>Local LU Alias :</td> <td><select name=\"lu_alias\" class=\"rightAligned\" value=\"$arg_lu_alias\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@list) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    # Partner LU name
print "<tr><td>Partner LU name :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"partner_lu_name\"  maxlength=\"17\" value=\"$arg_partner_lu_name\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr> ";
    
    #  Mode
print "<tr><td>Mode :</td> <td><select name=\"mode_name\" class=\"rightAligned\" value=\"$arg_mode_name\" >  ";
foreach $line (@modelist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #  TP name type
print "<tr><td>TP name type : </td> <td> <select name=\"tp_name_type\" class=\"rightAligned\" value=\"$arg_tp_name_type\" >  ";
print "<option value=\"APPLICATION_TP\" selected=\"selected\">APPLICATION_TP</option> ";
print "<option value=\"SNA_SERVICE_TP\">SNA_SERVICE_TP</option></select></td></tr>";
    
    #   TP name
print "<tr><td> TP name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tp_name\" maxlength=\"64\" value=\"$arg_tp_name\" /oninput=\"value=value.replace(/[^a-zA-Z0-9]/g,'')\" /></td></tr>";
    
    #   Conversation security
print "<tr><td> Conversation security : </td> <td> <select name=\"conversation_security_type\" class=\"rightAligned\" value=\"$arg_conversation_security_type\" >  ";
print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
print "<option value=\"PROGRAM\">PROGRAM</option> ";
print "<option value=\"PROGRAM_STRONG\">PROGRAM_STRONG</option> ";
print "<option value=\"SAME\">SAME</option></select></td></tr>";
    
    #   User ID
print "<tr><td>User ID : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"security_user_id\" maxlength=\"10\" value=\"$arg_security_user_id\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-.]/g,'')\" /></td></tr>";
    
    #   Password
print "<tr><td>Password : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"security_password\" maxlength=\"10\" value=\"$arg_security_password\" /oninput=\"value=value.replace(/[^a-zA-Z0-9.@#_-.:\(\)\$]/g,'')\" /></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

