#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_mode_name, $arg_description, $arg_max_neg_sess_lim, 
    $arg_plu_mode_session_limit, $arg_min_conwin_src, $arg_min_conloser_src, 
    $arg_auto_act, $arg_receive_pacing_win, $arg_default_ru_size,$arg_cos_name, 
    $arg_max_receive_pacing_win, $arg_max_ru_size_upp, $arg_compression, 
    $arg_max_ru_size_low,$arg_max_compress_level, $arg_max_decompress_level, 
    $description, $max_neg_sess_lim, $min_conwin_src, $min_conloser_src, 
    $cos_name, $max_receive_pacing_win, $receive_pacing_win, $max_ru_size_upp, 
    $plu_mode_session_limit, $auto_act, $max_ru_size_low, $time, 
    $remote_addr, $remote_port, $line, @data, @contents, @retval);

$arg_mode_name="";
$arg_description="";
$arg_max_neg_sess_lim="32767";
$arg_plu_mode_session_limit="2";
$arg_min_conloser_src="0";
$arg_min_conwin_src="1";
$arg_auto_act="0";
$arg_receive_pacing_win="4";
$arg_max_receive_pacing_win="0";
$arg_default_ru_size="YES";
$arg_max_ru_size_upp="1024";
$arg_max_ru_size_low="0";
$arg_cos_name="#CONNECT";
$arg_compression="PROHIBITED";
$arg_max_decompress_level="NONE";
$arg_max_compress_level="NONE";
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}   
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_mode.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #  * Name
print "<tr><td>* Mode name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"mode_name_unique\"  maxlength=\"8\" value=\"$arg_mode_name\" required=\"required\" oninput=\"value=value.replace(/[^A-Z0-9#_@]/g,'')\"  /></td></tr>";
    
    #  Description
print "<tr><td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\"  /></td></tr>";
    
print "<tr><td>Session limits :</td></tr>";
    
    #   Maximum number of sessions
print "<tr><td>Maximum number of sessions(0-32767) :</td><td><input type=\"text\" class=\"rightAligned\" name=\"max_neg_sess_lim\"  maxlength=\"5\" value=\"$arg_max_neg_sess_lim\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";

    #   Initial session limit
print "<tr><td>Initial session limit(0-32767) :</td><td><input type=\"text\" class=\"rightAligned\" name=\"plu_mode_session_limit\"  maxlength=\"5\" value=\"$arg_plu_mode_session_limit\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Min con. winner sessions
print "<tr><td>Min con. winner sessions(0-32767) :</td><td><input type=\"text\" class=\"rightAligned\" name=\"min_conwin_src\"  maxlength=\"5\" value=\"$arg_min_conwin_src\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Min con. loser sessions
print "<tr><td>Min con. loser sessions(0-32767) :</td><td><input type=\"text\" class=\"rightAligned\" name=\"min_conloser_src\"  maxlength=\"5\" value=\"$arg_min_conloser_src\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Auto-activate sessions
print "<tr><td>Auto-activate sessions(0-32767) </td> <td> <input type=\"text\" class=\"rightAligned\" name=\"auto_act\"  maxlength=\"5\" value=\"$arg_auto_act\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
print "<tr><td>Receive pacing window :</td></tr>";
   
    #   Initial
print "<tr><td>Initial(1-63) </td> <td> <input type=\"text\" class=\"rightAligned\" name=\"receive_pacing_win\"  maxlength=\"2\" value=\"$arg_receive_pacing_win\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Maximum
print "<tr><td>Maximum(0-32767) </td> <td> <input type=\"text\" class=\"rightAligned\" name=\"max_receive_pacing_win\"  maxlength=\"5\" value=\"$arg_max_receive_pacing_win\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #  Use default RU sizes?
print "<tr><td>Use default RU sizes ? </td> <td><select name=\"default_ru_size\"  class=\"rightAligned\" value=\"$arg_default_ru_size\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
  
print "<tr><td>If NO, </td></tr> ";
    
    #   Maximum RU size upper limit
print "<tr><td>Maximum RU size upper limit(0-61440) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_ru_size_upp\"  maxlength=\"5\" value=\"$arg_max_ru_size_upp\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #  Maximum RU size lower limit
print "<tr><td>Maximum RU size lower limit(0-61440) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_ru_size_low\"  maxlength=\"5\" value=\"$arg_max_ru_size_low\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   COS name
print "<tr><td>COS name : </td><td><input type=\"text\" class=\"rightAligned\" name=\"cos_name\"  maxlength=\"8\" value=\"$arg_cos_name\" /></td></tr>";
    
    #   Use compression
print "<tr><td>Use compression :</td> <td><select name=\"compression\"  class=\"rightAligned\" value=\"$arg_compression\" >  ";
print "<option value=\"REQUESTED\">REQUESTED</option> ";
print "<option value=\"PROHIBITED\" selected=\"selected\">PROHIBITED</option> </select></td></tr>";
   
    #    Maximum compression level
print "<tr><td> Maximum compression level : </td> <td><select name=\"max_compress_level\"  class=\"rightAligned\" value=\"$arg_max_compress_level\" >  ";
print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
print "<option value=\"RLE\">RLE</option> ";
print "<option value=\"LZ9\">LZ9</option> ";
print "<option value=\"LZ10\">LZ10</option> </select></td></tr>";
    
    #  Maximum decompression level
print "<tr><td>Maximum decompression level :</td> <td><select name=\"max_decompress_level\"  class=\"rightAligned\" value=\"$arg_max_decompress_level\" >  ";
print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
print "<option value=\"RLE\">RLE</option> ";
print "<option value=\"LZ9\">LZ9</option> ";
print "<option value=\"LZ10\">LZ10</option> </select></td></tr>";
    
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

