#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_pool_name, $arg_description, $arg_lu_name,  $description, 
    $lu_name, $remote_addr, $remote_port, $time, $line, @data, 
    @contents, @lulist, @retval);

$arg_pool_name="";
$arg_description="";
$arg_lu_name="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
        
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3 -d`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
        
    if ($line=~/^lu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        $lu_name=$data[1];
        next;
    }elsif ($line=~m/pool_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        if($data[1]=~m/""/)
        {
          push @lulist, $lu_name;
        }
        next;
    }
}

  
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addlupool.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 5px;\"> ";
print "<tbody> ";
    
    #   * Pool name
print "<tr> <td>* Pool name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"pool_name_unique\"  maxlength=\"8\" value=\"$arg_pool_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.#@\$]/g,'')\" /></td></tr>";
    
    #   Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #  LU name
print "<tr><td>LU name :</td> <td><select name=\"lu_name\" class=\"rightAligned\" value=\"$arg_lu_name\" >  ";
print "<option value=\"\" selected=\"selected\" ></option> ";
foreach $line (@lulist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

